/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.BodyVectorLayer;
import edu.colorado.phet.rotation.view.CircleNode;
import edu.colorado.phet.rotation.view.RotationBodyNode;
import edu.colorado.phet.rotation.view.RotationOriginNode;
import edu.colorado.phet.rotation.view.RotationPlatformNodeWithHandle;
import edu.colorado.phet.rotation.view.RotationRulerNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.geom.AffineTransform;

public class RotationPlayAreaNode
extends PNode {
    private PNode rotationPlatformNode;
    private PNode rotationBodyLayer = new PNode();
    private RotationModel rotationModel;
    private PNode vectorLayer = new PNode();
    private RotationOriginNode originNode;
    private RotationRulerNode rulerNode;
    private CircleNode circularMotionNode;
    PInputEventListener startSimWhenInteracting = new PBasicInputEventHandler(){

        public void mouseDragged(PInputEvent pInputEvent) {
            RotationPlayAreaNode.this.rotationModel.startRecording();
        }
    };

    public RotationPlayAreaNode(RotationModel rotationModel, VectorViewModel vectorViewModel, AngleUnitModel angleUnitModel) {
        int n;
        this.rotationModel = rotationModel;
        this.rotationPlatformNode = this.createRotationPlatformNode(rotationModel.getRotationPlatform());
        this.originNode = new RotationOriginNode(rotationModel.getRotationPlatform(), angleUnitModel);
        this.rulerNode = new RotationRulerNode(rotationModel.getRotationPlatform().getRadius() * 2.0, 0.75, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"}, RotationStrings.getString("units.mm"), 4, 14);
        this.rulerNode.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        this.rulerNode.setOffset(-this.rulerNode.getFullBounds().getWidth() / 2.0, 0.0);
        this.rulerNode.setVisible(false);
        this.addChild(this.rotationPlatformNode);
        for (n = 0; n < rotationModel.getNumRotationBodies(); ++n) {
            this.addRotationBodyNode(rotationModel.getRotationBody(n));
        }
        for (n = 0; n < rotationModel.getNumRotationBodies(); ++n) {
            this.addVectorNode(rotationModel.getRotationBody(n), vectorViewModel);
        }
        this.circularMotionNode = new CircleNode(rotationModel);
        this.circularMotionNode.setVisible(false);
        this.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        this.addChild(this.rotationBodyLayer);
        this.addChild(this.vectorLayer);
        this.addChild(this.originNode);
        this.addChild(this.rulerNode);
        this.addChild(this.circularMotionNode);
        this.rotationPlatformNode.addInputEventListener(this.startSimWhenInteracting);
    }

    protected PNode createRotationPlatformNode(RotationPlatform rotationPlatform) {
        return new RotationPlatformNodeWithHandle(rotationPlatform);
    }

    private void addVectorNode(RotationBody rotationBody, VectorViewModel vectorViewModel) {
        this.vectorLayer.addChild(new BodyVectorLayer(this.rotationModel, rotationBody, vectorViewModel));
    }

    public PNode getPlatformNode() {
        return this.rotationPlatformNode;
    }

    private void addRotationBodyNode(RotationBody rotationBody) {
        RotationBodyNode rotationBodyNode = new RotationBodyNode(this.rotationModel, rotationBody);
        rotationBodyNode.addInputEventListener(this.startSimWhenInteracting);
        this.rotationBodyLayer.addChild(rotationBodyNode);
    }

    public RulerNode getRulerNode() {
        return this.rulerNode;
    }

    public void setOriginNodeVisible(boolean bl) {
        this.originNode.setVisible(bl);
    }

    public void resetAll() {
        this.rulerNode.setVisible(false);
    }
}

