/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.piccolophet.nodes.HandleNode;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.PlatformNode2;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;

public class RotationPlatformNodeWithHandle
extends PlatformNode2 {
    private double handleHeight = 0.15;
    private PNode contentNode = new PNode();
    private HandleNode handleNode2;
    private RotationPlatform rotationPlatform;

    public RotationPlatformNodeWithHandle(RotationPlatform rotationPlatform) {
        super(rotationPlatform);
        this.rotationPlatform = rotationPlatform;
        this.handleNode2 = new HandleNode(this.handleHeight / 2.0 * 7.0, this.handleHeight * 7.0, Color.gray);
        this.handleNode2.setStroke(new BasicStroke(0.02f));
        this.handleNode2.setOffset(rotationPlatform.getRadius() + this.handleNode2.getFullBounds().getWidth() * 0.9, this.handleNode2.getFullBounds().getHeight() / 2.0);
        this.handleNode2.rotate(Math.PI);
        this.addChild(this.contentNode);
        this.contentNode.addChild(this.handleNode2);
        rotationPlatform.getPositionVariable().addListener(new IVariable.Listener(){

            public void valueChanged() {
                RotationPlatformNodeWithHandle.this.doUpdateAngle();
            }
        });
    }

    private void doUpdateAngle() {
        this.contentNode.setRotation(0.0);
        this.contentNode.setOffset(0.0, 0.0);
        this.contentNode.rotateAboutPoint(this.rotationPlatform.getPosition(), this.rotationPlatform.getCenter().getX(), this.rotationPlatform.getCenter().getY());
    }
}

