/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.motion.model.IPositionDriven;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.util.MathUtil;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class RotationPlatformDragHandler
extends PBasicInputEventHandler {
    private double initAngle;
    private Point2D initLoc;
    private final IPositionDriven environment;
    private final RotationPlatform rotationPlatform;
    private PNode rotationPlatformNode;

    public RotationPlatformDragHandler(PNode pNode, IPositionDriven iPositionDriven, RotationPlatform rotationPlatform) {
        this.rotationPlatformNode = pNode;
        this.environment = iPositionDriven;
        this.rotationPlatform = rotationPlatform;
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this.resetDrag(this.rotationPlatform.getAngle().getValue(), pInputEvent);
        this.environment.setPositionDriven();
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        double d = this.rotationPlatform.getAngularVelocity().getValue();
        if (Math.abs(d) > 0.05) {
            this.rotationPlatform.setVelocityDriven();
            this.rotationPlatform.setVelocity(d);
        }
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.rotationPlatformNode);
        Point2D point2D2 = this.rotationPlatform.getCenter();
        Vector2D.Double double_ = new Vector2D.Double(point2D2, this.initLoc);
        Vector2D.Double double_2 = new Vector2D.Double(point2D2, point2D);
        double d = double_2.getAngle() - double_.getAngle();
        d = MathUtil.clampAngle(d, -Math.PI, Math.PI);
        double d2 = this.initAngle + d;
        this.rotationPlatform.setAngle(d2);
        this.resetDrag(d2, pInputEvent);
    }

    private void resetDrag(double d, PInputEvent pInputEvent) {
        this.initAngle = d;
        this.initLoc = pInputEvent.getPositionRelativeTo(this.rotationPlatformNode);
    }
}

