/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;

public class RotationOriginNode
extends PNode {
    private HTMLNode htmlNode;
    private AngleUnitModel angleUnitModel;

    public RotationOriginNode(RotationPlatform rotationPlatform, AngleUnitModel angleUnitModel) {
        this.angleUnitModel = angleUnitModel;
        PhetPPath phetPPath = new PhetPPath(new Line2D.Double(0.0, 0.0, 0.44999999999999996, 0.0), (Stroke)new BasicStroke(0.03f), (Paint)Color.black);
        double d = 0.3;
        this.addChild(phetPPath);
        this.htmlNode = new HTMLNode("<html>\u03b8=0<sup>o</sup></html>");
        this.htmlNode.setFont(new PhetFont(16, true));
        this.htmlNode.setTransform(AffineTransform.getScaleInstance(0.015, -0.015));
        this.addChild(this.htmlNode);
        this.translate(rotationPlatform.getCenter().getX() + rotationPlatform.getRadius() + d, rotationPlatform.getCenter().getY());
        angleUnitModel.addListener(new AngleUnitModel.Listener(){

            public void changed() {
                RotationOriginNode.this.update();
            }
        });
        this.update();
    }

    private void update() {
        this.htmlNode.setHTML(this.angleUnitModel.isRadians() ? "\u03b8=0 radians" : "<html>\u03b8=0<sup>o</sup></html>");
    }
}

