/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.rotation.RotationResources;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class RotationBodyNode
extends PhetPNode {
    private RotationBody rotationBody;
    private PNode centerIndicatorNode;
    private PNode imageNode;
    private double modelSizeMeters = 1.0;

    public RotationBodyNode(final RotationBodyEnvironment rotationBodyEnvironment, final RotationBody rotationBody) {
        this.rotationBody = rotationBody;
        try {
            BufferedImage bufferedImage = RotationResources.loadBufferedImage(rotationBody.getImageName());
            this.imageNode = new PImage(bufferedImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.imageNode.translate(-this.imageNode.getFullBounds().getWidth() / 2.0, -this.imageNode.getFullBounds().getHeight() / 2.0);
        this.addChild(this.imageNode);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                rotationBody.setOffPlatform();
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(RotationBodyNode.this.getParent());
                Point2D point2D = rotationBody.getPosition();
                rotationBody.translate(pDimension.width, pDimension.height);
                if (rotationBodyEnvironment.platformContains(point2D.getX(), point2D.getY()) && rotationBody.isConstrained() && !rotationBodyEnvironment.platformContains(rotationBody.getX(), rotationBody.getY())) {
                    rotationBody.translate(-pDimension.width, -pDimension.height);
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                rotationBodyEnvironment.dropBody(rotationBody);
            }
        });
        rotationBody.addListener(new RotationBody.Adapter(){

            public void positionChanged() {
                RotationBodyNode.this.update();
            }

            public void orientationChanged() {
                RotationBodyNode.this.update();
            }
        });
        this.centerIndicatorNode = new PhetPPath(new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0), Color.white, new BasicStroke(1.0f), Color.black);
        this.addChild(this.centerIndicatorNode);
        this.update();
    }

    private void update() {
        double d = this.modelSizeMeters / this.imageNode.getWidth();
        PAffineTransform pAffineTransform = new PAffineTransform(AffineTransform.getScaleInstance(d, -d));
        Point2D point2D = this.getFullBounds().getCenter2D();
        pAffineTransform.rotate(-this.rotationBody.getOrientation(), point2D.getX(), point2D.getY());
        pAffineTransform.setOffset(this.rotationBody.getPosition().getX(), this.rotationBody.getPosition().getY());
        if (!pAffineTransform.equals(this.getTransform())) {
            this.setTransform(pAffineTransform);
        }
    }

    public static interface RotationBodyEnvironment {
        public void dropBody(RotationBody var1);

        public boolean platformContains(double var1, double var3);
    }
}

