/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.Function$LinearFunction;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class PlatformNode2
extends PNode {
    private RotationPlatform platform;
    private ArrayList segments = new ArrayList();
    private PNode outerEdgeLayer = new PNode();
    private PNode innerEdgeLayer = new PNode();
    private PNode foreground = new PNode();

    public PlatformNode2(RotationPlatform rotationPlatform) {
        this.platform = rotationPlatform;
        this.updateSegments();
        this.addChild(this.innerEdgeLayer);
        this.addChild(this.outerEdgeLayer);
        this.addChild(this.foreground);
        this.addChild(new DecorationLayer(rotationPlatform));
        rotationPlatform.getPositionVariable().addListener(new ITemporalVariable.ListenerAdapter(){

            public void valueChanged() {
                PlatformNode2.this.updateAngle();
            }
        });
        rotationPlatform.addListener(new RotationPlatform.Adapter(){

            public void radiusChanged() {
                PlatformNode2.this.updateSegments();
                PlatformNode2.this.updateAngle();
            }

            public void innerRadiusChanged() {
                PlatformNode2.this.updateSegments();
                PlatformNode2.this.updateAngle();
            }
        });
        rotationPlatform.addListener(new RotationPlatform.Adapter(){

            public void massChanged() {
                PlatformNode2.this.updateSegments();
                PlatformNode2.this.updateAngle();
            }
        });
        this.updateAngle();
    }

    protected void updateSegments() {
        this.clearSegments();
        Function$LinearFunction function$LinearFunction = new Function$LinearFunction(RotationPlatform.MIN_MASS, RotationPlatform.MAX_MASS, 0.0, 0.4);
        double d = function$LinearFunction.evaluate(this.platform.getMass());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j <= 3; ++j) {
                double d2 = (double)i * Math.PI * 2.0 / 4.0;
                Color color = Color.blue;
                if (j == 0) {
                    color = i % 2 == 0 ? Color.lightGray : Color.white;
                } else if (j == 1) {
                    color = i % 2 == 0 ? new Color(215, 215, 255) : new Color(240, 240, 255);
                } else if (j == 2) {
                    color = i % 2 == 0 ? new Color(140, 255, 140) : new Color(200, 255, 200);
                } else if (j == 3) {
                    color = i % 2 == 0 ? new Color(255, 215, 215) : new Color(255, 240, 240);
                }
                double d3 = (double)j + 0.0;
                double d4 = (double)(j + 1) - 0.0;
                Range range = new Range(d3, d4);
                Range range2 = new Range(this.platform.getInnerRadius(), this.platform.getRadius());
                boolean bl = range.overlaps(range2);
                if (!bl) continue;
                if (this.platform.getRadius() <= d4) {
                    d4 = this.platform.getRadius();
                }
                if (this.platform.getInnerRadius() >= d3) {
                    d3 = this.platform.getInnerRadius();
                }
                PlatformSegment platformSegment = new PlatformSegment(d2 + 0.0, d2 + 1.5707963267948966 - 0.0, d3, d4, -d, -d, d4 == this.platform.getRadius(), d3 == this.platform.getInnerRadius(), color);
                this.addSegment(platformSegment);
            }
        }
    }

    private void clearSegments() {
        while (this.segments.size() > 0) {
            PlatformSegment platformSegment = (PlatformSegment)this.segments.get(0);
            this.removeSegment(platformSegment);
        }
    }

    private void removeSegment(PlatformSegment platformSegment) {
        this.segments.remove(platformSegment);
        if (platformSegment.showOuterEdge) {
            this.outerEdgeLayer.removeChild(platformSegment.northPanel);
        }
        if (platformSegment.showInnerEdge) {
            this.innerEdgeLayer.removeChild(platformSegment.southPanel);
        }
        this.foreground.removeChild(platformSegment.body);
    }

    public void fullPaint(PPaintContext pPaintContext) {
        Object object = pPaintContext.getGraphics().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        pPaintContext.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        super.fullPaint(pPaintContext);
        pPaintContext.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, object == null ? RenderingHints.VALUE_ANTIALIAS_DEFAULT : object);
    }

    private void addSegment(PlatformSegment platformSegment) {
        this.segments.add(platformSegment);
        if (platformSegment.showOuterEdge) {
            this.outerEdgeLayer.addChild(platformSegment.northPanel);
        }
        if (platformSegment.showInnerEdge) {
            this.innerEdgeLayer.addChild(platformSegment.southPanel);
        }
        this.foreground.addChild(platformSegment.body);
    }

    protected void updateAngle() {
        for (int i = 0; i < this.segments.size(); ++i) {
            PlatformSegment platformSegment = (PlatformSegment)this.segments.get(i);
            platformSegment.updateAngle();
        }
    }

    private static class DecorationLayer
    extends PNode {
        private RotationPlatform platform;
        private PhetPPath outerRim;
        private PhetPPath innerRim;
        private PhetPPath angleZero;

        public DecorationLayer(RotationPlatform rotationPlatform) {
            this.platform = rotationPlatform;
            this.outerRim = new PhetPPath(new BasicStroke(0.04f), Color.black);
            this.addChild(this.outerRim);
            this.innerRim = new PhetPPath(new BasicStroke(0.04f), Color.black);
            this.addChild(this.innerRim);
            this.angleZero = new PhetPPath(new BasicStroke(0.04f), Color.gray);
            this.addChild(this.angleZero);
            rotationPlatform.getPositionVariable().addListener(new IVariable.Listener(){

                public void valueChanged() {
                    DecorationLayer.this.update();
                }
            });
            rotationPlatform.addListener(new RotationPlatform.Adapter(){

                public void radiusChanged() {
                    DecorationLayer.this.update();
                }

                public void innerRadiusChanged() {
                    DecorationLayer.this.update();
                }
            });
            this.update();
        }

        private void update() {
            this.outerRim.setPathTo(new Ellipse2D.Double(-this.platform.getRadius(), -this.platform.getRadius(), this.platform.getRadius() * 2.0, this.platform.getRadius() * 2.0));
            this.innerRim.setVisible(this.platform.getInnerRadius() > 0.0 && this.platform.getRadius() != this.platform.getInnerRadius());
            this.innerRim.setPathTo(new Ellipse2D.Double(-this.platform.getInnerRadius(), -this.platform.getInnerRadius(), this.platform.getInnerRadius() * 2.0, this.platform.getInnerRadius() * 2.0));
            double d = this.platform.getPosition();
            AbstractVector2D abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(this.platform.getInnerRadius(), d);
            AbstractVector2D abstractVector2D2 = Vector2D.Double.parseAngleAndMagnitude(this.platform.getRadius(), d);
            this.angleZero.setPathTo(new Line2D.Double(abstractVector2D.toPoint2D(), abstractVector2D2.toPoint2D()));
        }
    }

    private class PlatformSegment
    extends PNode {
        private double startAngle;
        private double endAngle;
        private double innerRadius;
        private double outerRadius;
        private PhetPPath body;
        private PhetPPath northPanel;
        private double edgeDX;
        private double edgeDY;
        private PhetPPath southPanel;
        private boolean showOuterEdge;
        private boolean showInnerEdge;

        public PlatformSegment(double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, Color color) {
            this.edgeDX = d5;
            this.edgeDY = d6;
            this.startAngle = d;
            this.endAngle = d2;
            this.innerRadius = d3;
            this.outerRadius = d4;
            this.showOuterEdge = bl;
            this.showInnerEdge = bl2;
            this.northPanel = new PhetPPath(color.darker(), (Stroke)new BasicStroke(0.03f), (Paint)Color.black);
            this.southPanel = new PhetPPath(color.darker(), (Stroke)new BasicStroke(0.03f), (Paint)Color.black);
            if (bl) {
                this.addChild(this.northPanel);
            }
            if (bl2) {
                this.addChild(this.southPanel);
            }
            this.body = new PhetPPath(color);
            this.addChild(this.body);
        }

        public void updateAngle() {
            double d = (this.endAngle - this.startAngle) * 360.0 / 2.0 / Math.PI;
            double d2 = -PlatformNode2.this.platform.getPosition() * 360.0 / Math.PI / 2.0;
            double d3 = this.startAngle * 360.0 / 2.0 / Math.PI + d2;
            Arc2D.Double double_ = new Arc2D.Double(-this.outerRadius, -this.outerRadius, this.outerRadius * 2.0, this.outerRadius * 2.0, d3, d, 0);
            Arc2D.Double double_2 = new Arc2D.Double(-this.outerRadius, -this.outerRadius, this.outerRadius * 2.0, this.outerRadius * 2.0, d3 + d, -d, 0);
            Arc2D.Double double_3 = new Arc2D.Double(-this.innerRadius, -this.innerRadius, this.innerRadius * 2.0, this.innerRadius * 2.0, this.startAngle * 360.0 / 2.0 / Math.PI + d + d2, -d, 0);
            Arc2D.Double double_4 = new Arc2D.Double(-this.innerRadius, -this.innerRadius, this.innerRadius * 2.0, this.innerRadius * 2.0, d3, d, 0);
            GeneralPath generalPath = this.toPathSegment(double_, double_3);
            this.body.setPathTo(generalPath);
            Arc2D.Double double_5 = new Arc2D.Double(-this.outerRadius + this.edgeDX, -this.outerRadius + this.edgeDY, this.outerRadius * 2.0, this.outerRadius * 2.0, d3, d, 0);
            Arc2D.Double double_6 = new Arc2D.Double(-this.innerRadius + this.edgeDX, -this.innerRadius + this.edgeDY, this.innerRadius * 2.0, this.innerRadius * 2.0, this.startAngle * 360.0 / 2.0 / Math.PI + d + d2, -d, 0);
            this.northPanel.setPathTo(this.toPathSegment(double_2, double_5));
            this.southPanel.setPathTo(this.toPathSegment(double_4, double_6));
        }

        private GeneralPath toPathSegment(Arc2D.Double double_, Arc2D.Double double_2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)double_.getStartPoint().getX(), (float)double_.getStartPoint().getY());
            generalPath.append(double_, true);
            generalPath.append(double_2, true);
            generalPath.closePath();
            return generalPath;
        }
    }

    static class Range {
        double min;
        double max;

        Range(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        public boolean overlaps(Range range) {
            return this.containsEndpoint(range) || range.containsEndpoint(this);
        }

        private boolean containsEndpoint(Range range) {
            return this.containsEndpoint(range.min) || this.containsEndpoint(range.max);
        }

        private boolean containsEndpoint(double d) {
            return d >= this.min && d <= this.max;
        }
    }
}

