/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.motion.graphs.TimeSeriesGraphSetNode;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.rotation.AbstractRotationModule;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.graphs.RotationGraphSet;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.view.RotationLayout;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import edu.colorado.phet.rotation.view.RotationPlayAreaNode;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public abstract class AbstractRotationSimulationPanel
extends BufferedPhetPCanvas {
    private AbstractRotationModule rotationModule;
    private RotationPlayAreaNode rotationPlayAreaNode;
    private TimeSeriesGraphSetNode timeSeriesGraphSetNode;
    private PSwing rotationControlPanelNode;
    private GraphSuiteSet rotationGraphSet;
    private GraphSetModel graphSetModel;
    private AngleUnitModel angleUnitModel = new AngleUnitModel(false);
    private JComponent controlPanel;
    private long paintTime = 0L;
    private PClip playAreaClip;
    public static final Color PLAY_AREA_BACKGROUND_COLOR = new Color(144, 240, 168);
    boolean okToPaint = false;

    public AbstractRotationSimulationPanel(final AbstractRotationModule abstractRotationModule, JFrame jFrame) {
        this.rotationModule = abstractRotationModule;
        this.setBackground(new RotationLookAndFeel().getBackgroundColor());
        this.rotationGraphSet = this.createRotationGraphSet();
        this.graphSetModel = new GraphSetModel(this.rotationGraphSet.getGraphSuite(0));
        this.rotationPlayAreaNode = this.createPlayAreaNode();
        final TimeSeriesModel timeSeriesModel = abstractRotationModule.getRotationModel().getTimeSeriesModel();
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void dataSeriesChanged() {
                if (timeSeriesModel.numPlaybackStates() == 0) {
                    abstractRotationModule.getRotationModel().clear();
                    AbstractRotationSimulationPanel.this.rotationGraphSet.clear();
                }
            }
        });
        this.timeSeriesGraphSetNode = new TimeSeriesGraphSetNode(this.graphSetModel, timeSeriesModel, 0.0125, 0.05);
        this.controlPanel = this.createControlPanel(this.getRulerNode(), jFrame);
        this.rotationControlPanelNode = new PSwing(this.controlPanel);
        this.addScreenChild(this.rotationControlPanelNode);
        this.playAreaClip = new PClip();
        this.playAreaClip.setPaint(PLAY_AREA_BACKGROUND_COLOR);
        this.playAreaClip.addChild(this.rotationPlayAreaNode);
        this.addScreenChild(this.playAreaClip);
        this.addScreenChild(this.timeSeriesGraphSetNode);
        this.relayout();
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                AbstractRotationSimulationPanel.this.relayout();
                AbstractRotationSimulationPanel.this.timeSeriesGraphSetNode.forceRepaintGraphs();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.addKeyListener(new PDebugKeyHandler());
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 116 && keyEvent.isAltDown()) {
                    AbstractRotationSimulationPanel.this.relayout();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 70) {
                    AbstractRotationSimulationPanel.this.setFlowLayout();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 65) {
                    AbstractRotationSimulationPanel.this.setAlignedLayout();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractRotationSimulationPanel.this.requestFocus();
            }
        });
        this.setAlignedLayout();
        this.angleUnitModel.addListener(new AngleUnitModel.Listener(){

            public void changed() {
                AbstractRotationSimulationPanel.this.timeSeriesGraphSetNode.forceRelayout();
            }
        });
        this.addGraphicsRepaintRectangleWorkaround();
    }

    private void addGraphicsRepaintRectangleWorkaround() {
        this.rotationModule.getClock().addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                AbstractRotationSimulationPanel.this.superPaintImmediately();
            }
        });
        new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractRotationSimulationPanel.this.rotationModule.getClock().isPaused()) {
                    AbstractRotationSimulationPanel.this.superPaintImmediately();
                }
            }
        }).start();
    }

    public void superPaintImmediately() {
        this.okToPaint = true;
        super.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        this.okToPaint = false;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (this.okToPaint) {
            super.paintImmediately(n, n2, n3, n4);
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        if (this.okToPaint) {
            super.paintImmediately(rectangle);
        }
    }

    public void resetAll() {
        this.rotationGraphSet.resetAll();
        this.graphSetModel.setGraphSuite(this.rotationGraphSet.getGraphSuite(0));
        this.rotationPlayAreaNode.resetAll();
        if (this.controlPanel instanceof Resettable) {
            ((Resettable)((Object)this.controlPanel)).reset();
        }
    }

    protected GraphSuiteSet createRotationGraphSet() {
        return new RotationGraphSet(this, this.rotationModule.getRotationModel(), this.getAngleUnitModel());
    }

    public GraphSuiteSet getRotationGraphSet() {
        return this.rotationGraphSet;
    }

    protected abstract JComponent createControlPanel(RulerNode var1, JFrame var2);

    protected abstract RotationPlayAreaNode createPlayAreaNode();

    private void setAlignedLayout() {
        this.timeSeriesGraphSetNode.setAlignedLayout();
    }

    private void setFlowLayout() {
        this.timeSeriesGraphSetNode.setFlowLayout();
    }

    private void relayout() {
        new RotationLayout(this, this.rotationPlayAreaNode, this.rotationControlPanelNode, this.timeSeriesGraphSetNode, this.rotationPlayAreaNode.getPlatformNode(), this.playAreaClip).layout();
    }

    public GraphSetModel getGraphSetModel() {
        return this.graphSetModel;
    }

    public AbstractRotationModule getAbstractRotationModule() {
        return this.rotationModule;
    }

    public RotationModel getRotationModel() {
        return this.rotationModule.getRotationModel();
    }

    public RulerNode getRulerNode() {
        return this.rotationPlayAreaNode.getRulerNode();
    }

    public void startApplication() {
        this.timeSeriesGraphSetNode.forceRelayout();
        this.timeSeriesGraphSetNode.forceRepaintGraphs();
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public AngleUnitModel getAngleUnitModel() {
        return this.angleUnitModel;
    }

    public VectorViewModel getVectorViewModel() {
        return this.rotationModule.getVectorViewModel();
    }
}

