/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.torque.AppliedForce;
import edu.colorado.phet.rotation.torque.BrakeNode;
import edu.colorado.phet.rotation.torque.RotationPlatformNodeWithMassDisplay;
import edu.colorado.phet.rotation.torque.RotationPlatformTorqueHandler;
import edu.colorado.phet.rotation.torque.TorqueModel;
import edu.colorado.phet.rotation.view.RotationPlayAreaNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class TorqueSimPlayAreaNode
extends RotationPlayAreaNode {
    private TorqueModel torqueModel;
    private PhetPPath appliedForceVector;
    private PhetPPath brakeForceVector;
    private PhetPPath tangentialComponentVector;
    private BrakeNode brakeNode;

    public TorqueSimPlayAreaNode(final TorqueModel torqueModel, VectorViewModel vectorViewModel, AngleUnitModel angleUnitModel) {
        super(torqueModel, vectorViewModel, angleUnitModel);
        this.torqueModel = torqueModel;
        this.getPlatformNode().addInputEventListener(new RotationPlatformTorqueHandler(this.getPlatformNode(), torqueModel, torqueModel.getRotationPlatform()));
        this.getPlatformNode().addInputEventListener(new CursorHandler());
        this.appliedForceVector = new PhetPPath(null, Color.blue, new BasicStroke(0.01f), Color.black);
        this.brakeForceVector = new PhetPPath(null, Color.red, new BasicStroke(0.01f), Color.black);
        this.tangentialComponentVector = new PhetPPath(null, Color.green, new BasicStroke(0.01f, 0, 0, 1.0f, new float[]{0.05f, 0.05f}, 0.0f), Color.darkGray);
        torqueModel.getAppliedForceObject().addListener(new AppliedForce.Listener(){

            public void changed() {
                TorqueSimPlayAreaNode.this.updateArrows();
            }
        });
        torqueModel.getBrakeForceObject().addListener(new AppliedForce.Listener(){

            public void changed() {
                TorqueSimPlayAreaNode.this.updateArrows();
            }
        });
        this.brakeNode = new BrakeNode(torqueModel.getRotationPlatform(), torqueModel);
        this.addChild(this.tangentialComponentVector);
        this.addChild(this.appliedForceVector);
        this.addChild(this.brakeForceVector);
        this.addChild(0, this.brakeNode);
        torqueModel.addListener(new TorqueModel.Adapter(){

            public void showComponentsChanged() {
                TorqueSimPlayAreaNode.this.tangentialComponentVector.setVisible(torqueModel.isShowComponents());
            }
        });
        this.updateArrows();
    }

    protected PNode createRotationPlatformNode(RotationPlatform rotationPlatform) {
        return new RotationPlatformNodeWithMassDisplay(rotationPlatform);
    }

    private void updateArrows() {
        Line2D.Double double_ = this.torqueModel.getAppliedForce();
        this.appliedForceVector.setPathTo(this.getForceShape(double_));
        this.brakeForceVector.setPathTo(this.getForceShape(this.torqueModel.getBrakeForceValue()));
        this.tangentialComponentVector.setPathTo(this.getForceShape(this.torqueModel.getTangentialAppliedForce()));
    }

    private Shape getForceShape(Line2D.Double double_) {
        return new Arrow(double_.getP1(), double_.getP2(), 0.25, 0.25, 0.1, 1.0, true).getShape();
    }
}

