/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.IMotionBody;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.model.RotationTemporalVariable;
import edu.colorado.phet.rotation.torque.AppliedForce;
import edu.colorado.phet.rotation.util.RotationUtil;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class TorqueModel
extends RotationModel {
    private AppliedForce appliedForceObject;
    private AppliedForce brakeForceObject;
    private DefaultTemporalVariable brakePressure = new RotationTemporalVariable();
    private DefaultTemporalVariable netForce = new RotationTemporalVariable();
    private DefaultTemporalVariable netTorque = new RotationTemporalVariable();
    private DefaultTemporalVariable momentOfInertia = new RotationTemporalVariable();
    private DefaultTemporalVariable angularMomentum = new RotationTemporalVariable();
    private UpdateStrategy forceDriven = new ForceDriven();
    private ArrayList listeners = new ArrayList();
    private boolean allowNonTangentialForces = DEFAULT_ALLOW_NONTANGENTIAL_FORCES;
    private boolean showComponents = DEFAULT_SHOW_COMPONENTS;
    private boolean inited = false;
    private boolean overwhelmingBrake = false;
    private static boolean DEFAULT_ALLOW_NONTANGENTIAL_FORCES = false;
    private static boolean DEFAULT_SHOW_COMPONENTS = true;

    public TorqueModel(ConstantDtClock constantDtClock) {
        super(constantDtClock);
        this.appliedForceObject = new AppliedForce(this.getRotationPlatform());
        this.brakeForceObject = new AppliedForce(this.getRotationPlatform());
        this.getRotationPlatform().setUpdateStrategy(this.forceDriven);
        this.inited = true;
        this.clear();
        this.getRotationPlatform().getVelocityVariable().addListener(new ITemporalVariable.ListenerAdapter(){

            public void valueChanged() {
                TorqueModel.this.updateBrakeForce();
            }
        });
        this.getRotationPlatform().addListener(new RotationPlatform.Adapter(){

            public void radiusChanged() {
                if (TorqueModel.this.appliedForceObject.getRadius() > TorqueModel.this.getRotationPlatform().getRadius()) {
                    TorqueModel.this.setAppliedForceFromRadius(TorqueModel.this.getRotationPlatform().getRadius());
                }
            }

            public void innerRadiusChanged() {
                if (TorqueModel.this.appliedForceObject.getRadius() < TorqueModel.this.getRotationPlatform().getInnerRadius()) {
                    TorqueModel.this.setAppliedForceFromRadius(TorqueModel.this.getRotationPlatform().getInnerRadius());
                }
            }
        });
        this.resetAll();
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        this.momentOfInertia.addValue(this.getRotationPlatform().getMomentOfInertia(), this.getTime());
        this.angularMomentum.addValue(this.getRotationPlatform().getMomentOfInertia() * this.getRotationPlatform().getVelocity(), this.getTime());
        this.defaultUpdate(this.brakePressure);
        this.defaultUpdate(this.netForce);
        this.defaultUpdate(this.netTorque);
        this.brakeForceObject.stepInTime(d, this.getTime());
        this.appliedForceObject.stepInTime(d, this.getTime());
        this.notifyAppliedForceChanged();
    }

    public void resetAll() {
        super.resetAll();
        if (this.inited) {
            this.setAppliedForceRadius(this.getRotationPlatform().getRadius());
            this.updateBrakeForce();
            this.updateNetForce();
            this.setAllowNonTangentialForces(DEFAULT_ALLOW_NONTANGENTIAL_FORCES);
            this.setShowComponents(DEFAULT_SHOW_COMPONENTS);
            this.setBrakePressure(0.0);
        }
    }

    protected void setPlaybackTime(double d) {
        super.setPlaybackTime(d);
        this.angularMomentum.setPlaybackTime(d);
        this.momentOfInertia.setPlaybackTime(d);
        this.netForce.setPlaybackTime(d);
        double d2 = this.brakePressure.getValue();
        this.brakePressure.setPlaybackTime(d);
        if (this.brakePressure.getValue() != d2) {
            this.notifyBrakePressureChanged();
        }
        this.netTorque.setPlaybackTime(d);
        this.appliedForceObject.setPlaybackTime(d);
        this.brakeForceObject.setPlaybackTime(d);
        this.notifyAppliedForceChanged();
    }

    public void clear() {
        super.clear();
        if (this.inited) {
            this.angularMomentum.clear();
            this.momentOfInertia.clear();
            this.appliedForceObject.clear();
            this.brakeForceObject.clear();
            this.netForce.clear();
            this.netTorque.clear();
            this.brakePressure.clear();
        }
    }

    public ITemporalVariable getBrakeForceMagnitudeVariable() {
        return this.brakeForceObject.getSignedForceSeries();
    }

    public double getBrakeForceMagnitude() {
        return this.brakeForceObject.getForceMagnitude();
    }

    public double getBrakePressure() {
        return this.brakePressure.getValue();
    }

    public void setBrakePressure(double d) {
        if (d != this.brakePressure.getValue()) {
            this.brakePressure.setValue(d);
            this.updateBrakeForce();
            this.notifyBrakePressureChanged();
        }
    }

    private void notifyBrakePressureChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).brakePressureChanged();
        }
    }

    private Line2D.Double computeBrakeForce() {
        Point2D.Double double_ = new Point2D.Double(this.getRotationPlatform().getRadius() * Math.sqrt(2.0) / 2.0, -this.getRotationPlatform().getRadius() * Math.sqrt(2.0) / 2.0);
        AbstractVector2D abstractVector2D = this.getBrakeForceVector();
        if (abstractVector2D == null) {
            return new Line2D.Double(double_, double_);
        }
        Point2D point2D = abstractVector2D.getDestination(double_);
        return new Line2D.Double(double_, point2D);
    }

    private AbstractVector2D getBrakeForceVector() {
        boolean bl;
        boolean bl2 = bl = this.getRotationPlatform().getVelocity() > 0.0;
        if (this.getRotationPlatform().getVelocity() == 0.0) {
            if (Math.abs(this.appliedForceObject.getTorque()) == 0.0) {
                return null;
            }
            bl = this.appliedForceObject.getTorque() > 0.0;
        }
        double d = this.brakePressure.getValue();
        double d2 = Math.abs(this.brakePressure.getValue() * this.getRotationPlatform().getRadius());
        double d3 = Math.abs(this.appliedForceObject.getTorque(this.getPlatformCenter()));
        double d4 = 1.0;
        if (d2 > d3 && Math.abs(this.getRotationPlatform().getVelocity()) < d4) {
            d = d3 / this.getRotationPlatform().getRadius();
            this.overwhelmingBrake = true;
        } else {
            this.overwhelmingBrake = false;
        }
        return Vector2D.Double.parseAngleAndMagnitude(d, 0.7853981633974483 + (bl ? Math.PI : 0.0));
    }

    private void updateBrakeForce() {
        this.brakeForceObject.setValue(this.computeBrakeForce());
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).brakeForceChanged();
        }
        this.updateNetForce();
    }

    private void updateNetForce() {
        this.netForce.setValue(this.getSignedNetForceValue());
    }

    private double getSignedNetForceValue() {
        return this.getAppliedForceObject().getSignedForce(this.getRotationPlatform().getCenter()) + this.getBrakeForceObject().getSignedForce(this.getRotationPlatform().getCenter());
    }

    public ITemporalVariable getAppliedTorqueTimeSeries() {
        return this.appliedForceObject.getTorqueSeries();
    }

    public ITemporalVariable getAppliedForceVariable() {
        return this.appliedForceObject.getSignedForceSeries();
    }

    public ITemporalVariable getNetForce() {
        return this.netForce;
    }

    public ITemporalVariable getNetTorque() {
        return this.netTorque;
    }

    public ITemporalVariable getBrakeTorque() {
        return this.brakeForceObject.getTorqueSeries();
    }

    public UpdateStrategy getForceDriven() {
        return this.forceDriven;
    }

    public ITemporalVariable getMomentOfInertiaTimeSeries() {
        return this.momentOfInertia;
    }

    public ITemporalVariable getAngularMomentumTimeSeries() {
        return this.angularMomentum;
    }

    public boolean isAllowNonTangentialForces() {
        return this.allowNonTangentialForces;
    }

    public void setAllowNonTangentialForces(boolean bl) {
        this.allowNonTangentialForces = bl;
    }

    public boolean isShowComponents() {
        return this.showComponents;
    }

    public void setShowComponents(boolean bl) {
        if (bl != this.showComponents) {
            this.showComponents = bl;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).showComponentsChanged();
            }
        }
    }

    public ITemporalVariable getRadiusSeries() {
        return this.appliedForceObject.getRadiusSeries();
    }

    public void setAppliedForce(double d, double d2) {
        this.setAppliedForce(new Line2D.Double(this.getRotationPlatform().getCenter().getX(), this.getRotationPlatform().getCenter().getY() - d, this.getRotationPlatform().getCenter().getX() + d2, this.getRotationPlatform().getCenter().getY() - d));
    }

    public void setAppliedForceFromRadius(double d) {
        if (d == 0.0) {
            d = 1.0E-6;
        }
        this.setAppliedForce(d, this.appliedForceObject.getSignedForce(this.getPlatformCenter()));
    }

    public void setAppliedForceRadius(double d) {
        this.setAppliedForceFromRadius(d);
    }

    public Line2D.Double getBrakeForceValue() {
        return this.brakeForceObject.toLine2D();
    }

    public AppliedForce getBrakeForceObject() {
        return this.brakeForceObject;
    }

    public AppliedForce getAppliedForceObject() {
        return this.appliedForceObject;
    }

    public ITemporalVariable getBrakeRadiusSeries() {
        return this.brakeForceObject.getRadiusSeries();
    }

    public double getAppliedForceRadius() {
        return this.appliedForceObject.getRadius();
    }

    private Point2D getPlatformCenter() {
        return this.getRotationPlatform().getCenter();
    }

    public Line2D.Double getAppliedForce() {
        return this.appliedForceObject.toLine2D();
    }

    public Line2D.Double getTangentialAppliedForce() {
        return this.getTangentialAppliedForce(this.getAppliedForce());
    }

    public void setAllowedAppliedForce(Line2D.Double double_) {
        this.setAppliedForce(this.getAllowedAppliedForce(double_));
    }

    public void setAppliedForce(Line2D.Double double_) {
        if (!RotationUtil.lineEquals(this.getAppliedForce(), double_)) {
            this.appliedForceObject.setValue(double_);
            this.updateNetForce();
            this.notifyAppliedForceChanged();
        }
    }

    private Line2D.Double getAllowedAppliedForce(Line2D.Double double_) {
        if (!this.allowNonTangentialForces) {
            double_ = this.getTangentialAppliedForce(double_);
        }
        return double_;
    }

    private Line2D.Double getTangentialAppliedForce(Line2D.Double double_) {
        AbstractVector2D abstractVector2D;
        Vector2D.Double double_2 = new Vector2D.Double(double_.getP1(), this.getRotationPlatform().getCenter());
        double_2.rotate(1.5707963267948966);
        Vector2D.Double double_3 = new Vector2D.Double(double_.getP1(), double_.getP2());
        if (double_2.dot(double_3) < 0.0) {
            double_2.rotate(Math.PI);
        }
        if ((abstractVector2D = double_2).getMagnitude() == 0.0) {
            return new Line2D.Double(double_.getP1(), double_.getP1());
        }
        double d = new Vector2D.Double(double_.getP1(), double_.getP2()).dot(abstractVector2D.getNormalizedInstance());
        abstractVector2D = d != 0.0 ? abstractVector2D.getInstanceOfMagnitude(d) : new Vector2D.Double(0.0, 0.0);
        return new Line2D.Double(double_.getP1(), abstractVector2D.getDestination(double_.getP1()));
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyAppliedForceChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).appliedForceChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void appliedForceChanged() {
        }

        public void showComponentsChanged() {
        }

        public void brakeForceChanged() {
        }

        public void brakePressureChanged() {
        }
    }

    public static interface Listener {
        public void appliedForceChanged();

        public void showComponentsChanged();

        public void brakeForceChanged();

        public void brakePressureChanged();
    }

    public class ForceDriven
    implements UpdateStrategy {
        public void update(IMotionBody iMotionBody, double d, double d2) {
            double d3 = iMotionBody.getVelocity();
            TorqueModel.this.netTorque.setValue(TorqueModel.this.appliedForceObject.getTorque() + TorqueModel.this.brakeForceObject.getTorque());
            double d4 = this.getMomentOfInertia() > 0.0 ? TorqueModel.this.netTorque.getValue() / this.getMomentOfInertia() : 0.0;
            double d5 = iMotionBody.getVelocity() + d4 * d;
            TorqueModel.this.updateBrakeForce();
            if (TorqueModel.this.overwhelmingBrake) {
                d5 = 0.0;
                d4 = 0.0;
            }
            iMotionBody.addAccelerationData(d4, d2);
            iMotionBody.addVelocityData(d5, d2);
            iMotionBody.addPositionData(iMotionBody.getPosition() + d5 * d, d2);
        }

        private double getMomentOfInertia() {
            return TorqueModel.this.getRotationPlatform().getMomentOfInertia();
        }
    }
}

