/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationClock;
import edu.colorado.phet.rotation.torque.TorqueIntroSimulationPanel;
import edu.colorado.phet.rotation.torque.TorqueModel;
import javax.swing.JFrame;

public class TorqueIntroModule
extends Module {
    private TorqueModel torqueModel;
    private VectorViewModel vectorViewModel = new VectorViewModel();
    private AngleUnitModel angleUnitModel = new AngleUnitModel(false);

    public TorqueIntroModule(JFrame jFrame) {
        super(RotationStrings.getString("module.intro.torque"), new RotationClock());
        this.torqueModel = new TorqueModel(this.getConstantDtClock());
        TorqueIntroSimulationPanel torqueIntroSimulationPanel = new TorqueIntroSimulationPanel(this, jFrame);
        this.setSimulationPanel(torqueIntroSimulationPanel);
        this.addRepaintOnActivateBehavior();
    }

    public ConstantDtClock getConstantDtClock() {
        return (ConstantDtClock)this.getClock();
    }

    public TorqueModel getTorqueModel() {
        return this.torqueModel;
    }

    public VectorViewModel getVectorViewModel() {
        return this.vectorViewModel;
    }

    public AngleUnitModel getAngleUnitModel() {
        return this.angleUnitModel;
    }

    public void reset() {
        super.reset();
        this.torqueModel.resetAll();
    }
}

