/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.torque.TorqueModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class RotationPlatformTorqueHandler
extends PBasicInputEventHandler {
    private PNode platformNode;
    private TorqueModel rotationModel;
    private RotationPlatform rotationPlatform;
    private Point2D sourcePoint;
    private Point2D dstPoint;

    public RotationPlatformTorqueHandler(PNode pNode, TorqueModel torqueModel, RotationPlatform rotationPlatform) {
        this.platformNode = pNode;
        this.rotationModel = torqueModel;
        this.rotationPlatform = rotationPlatform;
    }

    public void mousePressed(PInputEvent pInputEvent) {
        if (this.rotationPlatform.containsPosition(pInputEvent.getPositionRelativeTo(this.platformNode))) {
            this.sourcePoint = pInputEvent.getPositionRelativeTo(this.platformNode);
            this.dstPoint = pInputEvent.getPositionRelativeTo(this.platformNode);
            this.rotationModel.setAllowedAppliedForce(new Line2D.Double(this.sourcePoint, this.dstPoint));
        }
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        if (this.sourcePoint != null) {
            this.dstPoint = pInputEvent.getPositionRelativeTo(this.platformNode);
            this.rotationModel.setAllowedAppliedForce(new Line2D.Double(this.sourcePoint, this.dstPoint));
        }
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        if (this.sourcePoint != null) {
            this.dstPoint = new Point2D.Double(this.sourcePoint.getX(), this.sourcePoint.getY());
            this.rotationModel.setAllowedAppliedForce(new Line2D.Double(this.sourcePoint, this.dstPoint));
            this.sourcePoint = null;
        }
    }
}

