/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AlignedSliderSetLayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.controls.ResetButton;
import edu.colorado.phet.rotation.controls.RulerButton;
import edu.colorado.phet.rotation.controls.ShowVectorsControl;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.torque.AbstractTorqueModule;
import edu.colorado.phet.rotation.torque.NullLayoutStrategy;
import edu.colorado.phet.rotation.torque.TorqueModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FullTorqueControlPanel
extends VerticalLayoutPanel {
    private AbstractTorqueModule torqueModule;
    private JPanel leftPanel;

    public FullTorqueControlPanel(RulerNode rulerNode, final AbstractTorqueModule abstractTorqueModule, VectorViewModel vectorViewModel) {
        this.torqueModule = abstractTorqueModule;
        this.setBorder(BorderFactory.createTitledBorder(RotationStrings.getString("controls")));
        RotationPlatform rotationPlatform = abstractTorqueModule.getRotationModel().getRotationPlatform();
        AbstractValueControl[] abstractValueControlArray = this.getSliders(abstractTorqueModule, rotationPlatform);
        AlignedSliderSetLayoutStrategy alignedSliderSetLayoutStrategy = new AlignedSliderSetLayoutStrategy(abstractValueControlArray);
        alignedSliderSetLayoutStrategy.doLayout();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        for (int i = 0; i < abstractValueControlArray.length; ++i) {
            ((Container)verticalLayoutPanel).add(abstractValueControlArray[i]);
        }
        this.add(verticalLayoutPanel);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        this.leftPanel = new VerticalLayoutPanel();
        final JCheckBox jCheckBox = new JCheckBox(RotationStrings.getString("controls.allow.non.tangential.forces"), abstractTorqueModule.getTorqueModel().isAllowNonTangentialForces());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractTorqueModule.getTorqueModel().setAllowNonTangentialForces(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox(RotationStrings.getString("controls.show.components"), abstractTorqueModule.getTorqueModel().isShowComponents());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractTorqueModule.getTorqueModel().setShowComponents(jCheckBox2.isSelected());
            }
        });
        this.leftPanel.add(new RulerButton(rulerNode));
        ShowVectorsControl showVectorsControl = new ShowVectorsControl(vectorViewModel);
        this.leftPanel.add(showVectorsControl);
        this.leftPanel.add(jCheckBox2);
        this.leftPanel.add(jCheckBox);
        this.leftPanel.add(new ResetButton(abstractTorqueModule));
        horizontalLayoutPanel.add(this.leftPanel);
        this.add(Box.createRigidArea(new Dimension(30, 30)));
        this.add(horizontalLayoutPanel);
    }

    protected TorqueSlider[] getSliders(AbstractTorqueModule abstractTorqueModule, RotationPlatform rotationPlatform) {
        return new TorqueSlider[]{this.createOuterRadiusSlider(rotationPlatform), this.createInnerRadiusSlider(rotationPlatform), this.createMassSlider(rotationPlatform), this.createFrictionSlider(abstractTorqueModule)};
    }

    protected TorqueSlider createFrictionSlider(final AbstractTorqueModule abstractTorqueModule) {
        final TorqueSlider torqueSlider = new TorqueSlider(0.0, 10.0, abstractTorqueModule.getTorqueModel().getBrakeForceMagnitude(), RotationStrings.getString("variable.force.of.brake"), "0.00", RotationStrings.getString("units.n"));
        torqueSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                abstractTorqueModule.getTorqueModel().setBrakePressure(torqueSlider.getValue());
            }
        });
        abstractTorqueModule.getTorqueModel().addListener(new TorqueModel.Adapter(){

            public void brakePressureChanged() {
                torqueSlider.setValue(abstractTorqueModule.getTorqueModel().getBrakePressure());
            }
        });
        return torqueSlider;
    }

    protected TorqueSlider createMassSlider(final RotationPlatform rotationPlatform) {
        final TorqueSlider torqueSlider = new TorqueSlider(RotationPlatform.MIN_MASS, RotationPlatform.MAX_MASS, rotationPlatform.getMass(), RotationStrings.getString("variable.platform.mass"), "0.00", RotationStrings.getString("units.kg"));
        torqueSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationPlatform.setMass(torqueSlider.getValue());
            }
        });
        rotationPlatform.addListener(new RotationPlatform.Adapter(){

            public void massChanged() {
                torqueSlider.setValue(rotationPlatform.getMass());
            }
        });
        return torqueSlider;
    }

    protected TorqueSlider createInnerRadiusSlider(final RotationPlatform rotationPlatform) {
        final TorqueSlider torqueSlider = new TorqueSlider(0.0, 4.0, rotationPlatform.getInnerRadius(), RotationStrings.getString("variable.r.inner.radius"), "0.00", RotationStrings.getString("units.mm"));
        torqueSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationPlatform.setInnerRadius(torqueSlider.getValue());
                if (torqueSlider.getValue() > rotationPlatform.getRadius()) {
                    rotationPlatform.setRadius(torqueSlider.getValue());
                }
            }
        });
        rotationPlatform.addListener(new RotationPlatform.Adapter(){

            public void innerRadiusChanged() {
                torqueSlider.setValue(rotationPlatform.getInnerRadius());
            }
        });
        return torqueSlider;
    }

    protected TorqueSlider createOuterRadiusSlider(final RotationPlatform rotationPlatform) {
        final TorqueSlider torqueSlider = new TorqueSlider(0.0, 4.0, rotationPlatform.getRadius(), RotationStrings.getString("variable.r.outer.radius"), "0.00", RotationStrings.getString("units.mm"));
        torqueSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationPlatform.setRadius(torqueSlider.getValue());
                if (torqueSlider.getValue() < rotationPlatform.getInnerRadius()) {
                    rotationPlatform.setInnerRadius(torqueSlider.getValue());
                }
            }
        });
        rotationPlatform.addListener(new RotationPlatform.Adapter(){

            public void radiusChanged() {
                torqueSlider.setValue(rotationPlatform.getRadius());
            }
        });
        return torqueSlider;
    }

    public static class TorqueSlider
    extends LinearValueControl {
        public TorqueSlider(double d, double d2, double d3, String string, String string2, String string3) {
            super(d, d2, string, string2, string3, new NullLayoutStrategy());
            this.setValue(d3);
            this.setMinorTickSpacing((d2 - d) / 20.0);
            this.setPaintTickLabels(false);
            this.getSlider().setPreferredSize(new Dimension((int)((double)this.getSlider().getPreferredSize().width * 0.7), this.getSlider().getPreferredSize().height));
        }
    }
}

