/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.Function$LinearFunction;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.rotation.RotationResources;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.torque.TorqueModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;

public class BrakeNode
extends PNode {
    private RotationPlatform rotationPlatform;
    private TorqueModel torqueModel;
    private PNode im;
    private double BRAKE_SCALE = 5.0;

    public BrakeNode(final RotationPlatform rotationPlatform, final TorqueModel torqueModel) {
        this.rotationPlatform = rotationPlatform;
        this.torqueModel = torqueModel;
        rotationPlatform.addListener(new RotationPlatform.Adapter(){

            public void radiusChanged() {
                BrakeNode.this.updateTransform();
            }
        });
        torqueModel.addListener(new TorqueModel.Adapter(){

            public void brakePressureChanged() {
                BrakeNode.this.updateTransform();
            }
        });
        try {
            this.im = this.createImageWithHandle();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        double d = 0.009;
        this.im.transformBy(AffineTransform.getScaleInstance(-d, d));
        this.im.rotate(1.5707963267948966);
        this.im.translate(-this.im.getFullBounds().getWidth() / d, 0.0);
        this.addChild(this.im);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){
            Point2D pressPoint = null;

            public void mousePressed(PInputEvent pInputEvent) {
                this.pressPoint = this.getPoint(pInputEvent);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                if (this.pressPoint != null) {
                    Vector2D.Double double_;
                    Point2D point2D = this.getPoint(pInputEvent);
                    Vector2D.Double double_2 = new Vector2D.Double(this.pressPoint, point2D);
                    double d = double_2.dot(double_ = new Vector2D.Double(BrakeNode.this.getFullBounds().getCenter2D(), rotationPlatform.getCenter())) / 2.0;
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    torqueModel.setBrakePressure(MathUtil.clamp(0.0, d *= BrakeNode.this.BRAKE_SCALE, 10.0));
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                this.pressPoint = null;
                torqueModel.setBrakePressure(0.0);
            }

            private Point2D getPoint(PInputEvent pInputEvent) {
                return pInputEvent.getPositionRelativeTo(BrakeNode.this.getParent());
            }
        });
        this.updateTransform();
    }

    private PNode createImageWithHandle() throws IOException {
        PImage pImage = new PImage(RotationResources.loadBufferedImage("brake-pad.gif"));
        return pImage;
    }

    private void updateTransform() {
        double d = -0.7853981633974483;
        Function$LinearFunction function$LinearFunction = new Function$LinearFunction(0.0, 1.0, 0.0, -0.09);
        double d2 = function$LinearFunction.evaluate(this.torqueModel.getBrakePressure());
        d2 = MathUtil.clamp(-0.09, d2, 0.0);
        if (this.torqueModel.getBrakePressure() == 0.0) {
            d2 = 0.05;
        }
        AbstractVector2D abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(this.rotationPlatform.getRadius() + d2, d);
        this.setOffset(abstractVector2D.getDestination(this.rotationPlatform.getCenter()));
        this.setRotation(d);
    }
}

