/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.model.RotationTemporalVariable;
import edu.colorado.phet.rotation.util.RotationUtil;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class AppliedForce {
    private DefaultTemporalVariable appliedForceSrcX = new RotationTemporalVariable();
    private DefaultTemporalVariable appliedForceSrcY = new RotationTemporalVariable();
    private DefaultTemporalVariable appliedForceDstX = new RotationTemporalVariable();
    private DefaultTemporalVariable appliedForceDstY = new RotationTemporalVariable();
    private DefaultTemporalVariable radius = new RotationTemporalVariable();
    private DefaultTemporalVariable signedForce = new RotationTemporalVariable();
    private DefaultTemporalVariable torque = new RotationTemporalVariable();
    private ArrayList listeners = new ArrayList();
    private RotationPlatform platform;

    public AppliedForce(RotationPlatform rotationPlatform) {
        this.platform = rotationPlatform;
        this.radius.setValue(rotationPlatform.getRadius());
    }

    public double getTorque() {
        return this.getTorque(this.platform.getCenter());
    }

    public void stepInTime(double d, double d2) {
        this.torque.setValue(this.getTorque());
        this.defaultUpdate(this.radius, d2);
        this.defaultUpdate(this.torque, d2);
        this.defaultUpdate(this.signedForce, d2);
        this.defaultUpdate(this.appliedForceSrcX, d2);
        this.defaultUpdate(this.appliedForceSrcY, d2);
        this.defaultUpdate(this.appliedForceDstX, d2);
        this.defaultUpdate(this.appliedForceDstY, d2);
        this.notifyChanged();
    }

    private void defaultUpdate(ITemporalVariable iTemporalVariable, double d) {
        iTemporalVariable.addValue(iTemporalVariable.getValue(), d);
    }

    public void setPlaybackTime(double d) {
        this.radius.setPlaybackTime(d);
        this.torque.setPlaybackTime(d);
        this.signedForce.setPlaybackTime(d);
        this.appliedForceSrcX.setPlaybackTime(d);
        this.appliedForceSrcY.setPlaybackTime(d);
        this.appliedForceDstX.setPlaybackTime(d);
        this.appliedForceDstY.setPlaybackTime(d);
        this.notifyChanged();
    }

    public void clear() {
        this.radius.clear();
        this.torque.clear();
        this.signedForce.clear();
        this.appliedForceSrcX.clear();
        this.appliedForceSrcY.clear();
        this.appliedForceDstX.clear();
        this.appliedForceDstY.clear();
        this.notifyChanged();
    }

    public ITemporalVariable getRadiusSeries() {
        return this.radius;
    }

    public Point2D getP1() {
        return this.toLine2D().getP1();
    }

    public Point2D getP2() {
        return this.toLine2D().getP2();
    }

    public Line2D.Double toLine2D() {
        return new Line2D.Double(this.appliedForceSrcX.getValue(), this.appliedForceSrcY.getValue(), this.appliedForceDstX.getValue(), this.appliedForceDstY.getValue());
    }

    public void setValue(Line2D.Double double_) {
        if (!RotationUtil.lineEquals(this.toLine2D(), double_)) {
            this.appliedForceSrcX.setValue(double_.getX1());
            this.appliedForceSrcY.setValue(double_.getY1());
            this.appliedForceDstX.setValue(double_.getX2());
            this.appliedForceDstY.setValue(double_.getY2());
            this.updateDependentValues(double_);
            this.notifyChanged();
        }
    }

    private void updateDependentValues(Line2D.Double double_) {
        this.radius.setValue(new Vector2D.Double(double_.getP1()).getMagnitude());
        this.signedForce.setValue(this.getForceMagnitude() * (double)MathUtil.getSign(this.getTorque()));
        this.torque.setValue(this.getTorque());
    }

    private void notifyChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).changed();
        }
    }

    public double getForceMagnitude() {
        return this.getP1().distance(this.getP2());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getSignedForce(Point2D point2D) {
        return this.getForceMagnitude() * (double)MathUtil.getSign(this.getTorque(point2D));
    }

    public double getTorque(Point2D point2D) {
        Vector2D.Double double_ = new Vector2D.Double(point2D, this.getP1());
        Vector2D.Double double_2 = new Vector2D.Double(this.getP1(), this.getP2());
        return -double_.getCrossProductScalar(double_2);
    }

    public double getRadius() {
        return this.getRadiusSeries().getValue();
    }

    public ITemporalVariable getSignedForceSeries() {
        return this.signedForce;
    }

    public DefaultTemporalVariable getTorqueSeries() {
        return this.torque;
    }

    public static interface Listener {
        public void changed();
    }
}

