/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.tests;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.JFrame;

public class CircularRegression {
    private JFrame frame = new JFrame();
    private PhetPPath circlePath;
    private PNode pointLayer = new PNode();
    private Circle lastCircle;
    static double alpha = 0.01;
    private static double epsilon = 1.0E-5;

    public CircularRegression() {
        this.frame.setDefaultCloseOperation(3);
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        phetPCanvas.getLayer().addChild(this.pointLayer);
        phetPCanvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                CircularRegression.this.addPoint(mouseEvent.getPoint());
                if (mouseEvent.isControlDown()) {
                    CircularRegression.this.pointLayer.removeAllChildren();
                    CircularRegression.this.updateCircle();
                }
            }
        });
        phetPCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                CircularRegression.this.addPoint(mouseEvent.getPoint());
                while (CircularRegression.this.pointLayer.getChildrenCount() > 100) {
                    CircularRegression.this.pointLayer.removeChild(0);
                }
                CircularRegression.this.updateCircle();
            }
        });
        this.frame.setContentPane(phetPCanvas);
        this.circlePath = new PhetPPath(new BasicStroke(2.0f), Color.red);
        phetPCanvas.getLayer().addChild(this.circlePath);
    }

    private void addPoint(Point point) {
        PhetPPath phetPPath = new PhetPPath(new Ellipse2D.Double(point.getX() - 2.0, point.getY() - 2.0, 4.0, 4.0), Color.blue, new BasicStroke(1.0f), Color.black);
        this.pointLayer.addChild(phetPPath);
        this.updateCircle();
    }

    private Circle updateCircle() {
        this.lastCircle = this.getCircle(this.getPoints(), 30, this.lastCircle);
        this.circlePath.setPathTo(this.lastCircle.toEllipse());
        return this.lastCircle;
    }

    public Circle getCircle(Point2D[] point2DArray, int n, Circle circle) {
        double[] dArray = new double[]{circle == null ? CircularRegression.avgX(point2DArray) : circle.x, circle == null ? CircularRegression.avgY(point2DArray) : circle.y, circle == null ? 1.0 : circle.r};
        for (int i = 0; i < n; ++i) {
            dArray = CircularRegression.update(dArray, point2DArray);
        }
        return new Circle(dArray[0], dArray[1], dArray[2]);
    }

    private static double avgX(Point2D[] point2DArray) {
        double d = 0.0;
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            d += point2D.getX();
        }
        return d / (double)point2DArray.length;
    }

    private static double avgY(Point2D[] point2DArray) {
        double d = 0.0;
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            d += point2D.getY();
        }
        return d / (double)point2DArray.length;
    }

    private static double[] update(double[] dArray, Point2D[] point2DArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] + alpha * CircularRegression.numgrad(i, dArray, point2DArray);
        }
        return dArray2;
    }

    private static double numgrad(int n, double[] dArray, Point2D[] point2DArray) {
        int n2 = n;
        dArray[n2] = dArray[n2] + epsilon;
        double d = CircularRegression.getError(dArray, point2DArray);
        int n3 = n;
        dArray[n3] = dArray[n3] + -2.0 * epsilon;
        double d2 = CircularRegression.getError(dArray, point2DArray);
        int n4 = n;
        dArray[n4] = dArray[n4] + epsilon;
        return (d2 - d) / (2.0 * epsilon);
    }

    private static double getError(double[] dArray, Point2D[] point2DArray) {
        double d = 0.0;
        for (int i = 0; i < point2DArray.length; ++i) {
            d += CircularRegression.distance(dArray, point2DArray[i]);
        }
        return d;
    }

    private static double distance(double[] dArray, Point2D point2D) {
        double d = point2D.distance(dArray[0], dArray[1]);
        if (d > dArray[2]) {
            return d - dArray[2];
        }
        return dArray[2] - d;
    }

    private Point2D[] getPoints() {
        Point2D[] point2DArray = new Point2D[this.pointLayer.getChildrenCount()];
        for (int i = 0; i < point2DArray.length; ++i) {
            point2DArray[i] = this.pointLayer.getChild(i).getFullBounds().getCenter2D();
        }
        return point2DArray;
    }

    public static class Circle {
        double x;
        double y;
        double r;

        public Circle(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.r = d3;
        }

        public Shape toEllipse() {
            return new Ellipse2D.Double(this.x - this.r, this.y - this.r, this.r * 2.0, this.r * 2.0);
        }

        public Point2D.Double getCenter2D() {
            return new Point2D.Double(this.x, this.y);
        }

        public String toString() {
            return "Circle x=" + this.x + ", y=" + this.y + " r=" + this.r;
        }

        public double getRadius() {
            return this.r;
        }

        public double getMeanSquaredError(Point2D[] point2DArray) {
            if (point2DArray.length == 0) {
                return 0.0;
            }
            double d = 0.0;
            for (int i = 0; i < point2DArray.length; ++i) {
                Point2D point2D = point2DArray[i];
                d += this.getSquaredError(point2D);
            }
            return d / (double)point2DArray.length;
        }

        public double getSquaredError(Point2D point2D) {
            double d = point2D.distance(this.x, this.y);
            if (d > this.r) {
                return (d - this.r) * (d - this.r);
            }
            return (this.r - d) * (this.r - d);
        }
    }
}

