/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.torque.TorqueModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RotationPlatform
extends MotionBody {
    private SerializablePoint2D center = new SerializablePoint2D(0.0, 0.0);
    private DefaultTemporalVariable radius = new DefaultTemporalVariable(4.0);
    private DefaultTemporalVariable innerRadius = new DefaultTemporalVariable(0.0);
    private DefaultTemporalVariable mass = new DefaultTemporalVariable(this.getDefaultMass());
    private transient ArrayList listeners = new ArrayList();
    private boolean displayGraph = true;
    public static final double MIN_MASS = RotationPlatform.getDefaultMassValue(0.0, 4.0) / 10.0;
    public static final double MAX_MASS = RotationPlatform.getDefaultMassValue(0.0, 4.0) * 2.0;

    public RotationPlatform() {
        super(RotationModel.getTimeSeriesFactory());
    }

    private static double getDefaultMassValue(double d, double d2) {
        return 1.0 / ((d * d + d2 * d2) / 2.0);
    }

    public void setTime(double d) {
        super.setTime(d);
        this.radius.setPlaybackTime(d);
        this.innerRadius.setPlaybackTime(d);
        this.mass.setPlaybackTime(d);
        this.notifyRadiusChanged();
        this.notifyInnerRadiusChanged();
        this.notifyMassChanged();
    }

    private double getDefaultMass() {
        return 1.0 / ((this.innerRadius.getValue() * this.innerRadius.getValue() + this.radius.getValue() * this.radius.getValue()) / 2.0);
    }

    public boolean containsPosition(Point2D point2D) {
        return point2D.distance(this.center) <= this.radius.getValue() && point2D.distance(this.center) >= this.innerRadius.getValue();
    }

    public Point2D getCenter() {
        return this.center;
    }

    public boolean getDisplayGraph() {
        return this.displayGraph;
    }

    public void reset() {
        super.reset();
        this.setRadius(4.0);
        this.setInnerRadius(0.0);
        this.setDisplayGraph(true);
        this.setMass(this.getDefaultMass());
    }

    public void setDisplayGraph(boolean bl) {
        if (this.displayGraph != bl) {
            this.displayGraph = bl;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).displayGraphChanged();
            }
        }
    }

    public double getRadius() {
        return this.radius.getValue();
    }

    public void setAngle(double d) {
        super.setPosition(d);
    }

    public void setRadius(final double d) {
        if (this.radius.getValue() != d) {
            this.changeValueConserveMomentum(new Setter(){

                public void setValue() {
                    RotationPlatform.this.radius.setValue(d);
                }
            });
            this.notifyRadiusChanged();
        }
    }

    public void setInnerRadius(final double d) {
        if (this.innerRadius.getValue() != d) {
            this.changeValueConserveMomentum(new Setter(){

                public void setValue() {
                    RotationPlatform.this.innerRadius.setValue(d);
                }
            });
            this.notifyInnerRadiusChanged();
        }
    }

    private void changeValueConserveMomentum(Setter setter) {
        double d = this.getAngularMomentum();
        setter.setValue();
        this.setVelocityForAngMom(d);
    }

    private void setVelocityForAngMom(double d) {
        this.setVelocity(d / this.getMomentOfInertia());
    }

    private double getAngularMomentum() {
        return this.getMomentOfInertia() * this.getVelocity();
    }

    public void stepInTime(double d, double d2) {
        super.stepInTime(d, d2);
        this.radius.addValue(this.radius.getValue(), d);
        this.innerRadius.addValue(this.innerRadius.getValue(), d);
        this.mass.addValue(this.mass.getValue(), d);
    }

    public void clear() {
        this.radius.clear();
        this.innerRadius.clear();
        this.mass.clear();
    }

    private void notifyInnerRadiusChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).innerRadiusChanged();
        }
    }

    public double getInnerRadius() {
        return this.innerRadius.getValue();
    }

    public double getMomentOfInertia() {
        return 0.5 * this.mass.getValue() * (this.innerRadius.getValue() * this.innerRadius.getValue() + this.radius.getValue() * this.radius.getValue());
    }

    public double getMass() {
        return this.mass.getValue();
    }

    public void setMass(final double d) {
        if (this.mass.getValue() != d) {
            this.changeValueConserveMomentum(new Setter(){

                public void setValue() {
                    RotationPlatform.this.mass.setValue(d);
                }
            });
            this.notifyMassChanged();
        }
    }

    private void notifyMassChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).massChanged();
        }
    }

    public ITemporalVariable getAngularAcceleration() {
        return super.getAccelerationVariable();
    }

    public ITemporalVariable getAngularVelocity() {
        return super.getVelocityVariable();
    }

    public ITemporalVariable getAngle() {
        return super.getPositionVariable();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyRadiusChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).radiusChanged();
        }
    }

    public boolean isForceDriven() {
        return super.getUpdateStrategy() instanceof TorqueModel.ForceDriven;
    }

    public static class Adapter
    implements Listener {
        public void radiusChanged() {
        }

        public void innerRadiusChanged() {
        }

        public void displayGraphChanged() {
        }

        public void massChanged() {
        }
    }

    public static interface Listener {
        public void radiusChanged();

        public void innerRadiusChanged();

        public void displayGraphChanged();

        public void massChanged();
    }

    public static interface Setter {
        public void setValue();
    }
}

