/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.HeuristicPrunedTimeSeries;
import edu.colorado.phet.common.motion.model.IPositionDriven;
import edu.colorado.phet.common.motion.model.MotionModel;
import edu.colorado.phet.common.motion.model.MotionTimeSeriesModel;
import edu.colorado.phet.common.motion.model.TimeSeriesFactory;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.timeseries.model.RecordableModel;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.RotationBodyNode;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RotationModel
extends MotionModel
implements IPositionDriven,
RotationBodyNode.RotationBodyEnvironment {
    private RotationPlatform rotationPlatform;
    private ArrayList rotationBodies = new ArrayList();
    private static TimeSeriesFactory timeSeriesFactory = new TimeSeriesFactory(){

        public DefaultTimeSeries createTimeSeries() {
            return new HeuristicPrunedTimeSeries(20.0);
        }
    };

    public RotationModel(ConstantDtClock constantDtClock) {
        super(constantDtClock, new HeuristicPrunedTimeSeries.Factory(20.0));
        this.rotationPlatform = new RotationPlatform();
        this.addRotationBody(new RotationBody("ladybug.gif", true));
        RotationBody rotationBody = new RotationBody("valessiobrito_Bug_Buddy_Vec.png");
        rotationBody.setDisplayGraph(false);
        this.addRotationBody(rotationBody);
        this.resetAll();
    }

    protected TimeSeriesModel createTimeSeriesModel(RecordableModel recordableModel, ConstantDtClock constantDtClock) {
        return new MotionTimeSeriesModel(recordableModel, constantDtClock);
    }

    private void resetBody2(RotationBody rotationBody) {
        rotationBody.clearVelocityAndAcceleration();
        rotationBody.setPosition(this.rotationPlatform.getCenter().getX() - this.rotationPlatform.getRadius() * Math.sqrt(2.0) / 2.0, this.rotationPlatform.getCenter().getY() - this.rotationPlatform.getRadius());
        rotationBody.setOffPlatform();
        rotationBody.setOrientation(0.0);
        rotationBody.clearWindingNumber();
        rotationBody.clearAngularVelocity();
    }

    private void resetBody1(RotationBody rotationBody) {
        rotationBody.clearVelocityAndAcceleration();
        rotationBody.setPosition(this.rotationPlatform.getCenter().getX() + this.rotationPlatform.getRadius() / 2.0, this.rotationPlatform.getCenter().getY());
        rotationBody.setOnPlatform(this.rotationPlatform);
        rotationBody.setOrientation(0.0);
        rotationBody.clearWindingNumber();
        rotationBody.clearAngularVelocity();
    }

    public void resetAll() {
        super.resetAll();
        this.rotationPlatform.reset();
        this.resetBody1(this.getRotationBody(0));
        this.resetBody2(this.getRotationBody(1));
        this.getTimeSeriesModel().setRecordMode();
    }

    protected void setPlaybackTime(double d) {
        super.setPlaybackTime(d);
        this.rotationPlatform.setTime(d);
        for (int i = 0; i < this.rotationBodies.size(); ++i) {
            this.getRotationBody(i).setTime(d);
        }
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        this.rotationPlatform.stepInTime(this.getTime(), d);
        for (int i = 0; i < this.rotationBodies.size(); ++i) {
            this.getRotationBody(i).stepInTime(this.getTime(), d);
        }
    }

    public void clear() {
        super.clear();
        this.rotationPlatform.clear();
        for (int i = 0; i < this.rotationBodies.size(); ++i) {
            this.getRotationBody(i).clear();
        }
    }

    public void dropBody(RotationBody rotationBody) {
        if (this.rotationPlatform.containsPosition(rotationBody.getPosition())) {
            rotationBody.setOnPlatform(this.rotationPlatform);
        } else {
            rotationBody.setOffPlatform();
        }
    }

    public boolean platformContains(double d, double d2) {
        return this.rotationPlatform.containsPosition(new Point2D.Double(d, d2));
    }

    public RotationPlatform getRotationPlatform() {
        return this.rotationPlatform;
    }

    private void addRotationBody(RotationBody rotationBody) {
        this.rotationBodies.add(rotationBody);
    }

    public int getNumRotationBodies() {
        return this.rotationBodies.size();
    }

    public RotationBody getRotationBody(int n) {
        return (RotationBody)this.rotationBodies.get(n);
    }

    public void setPositionDriven() {
        this.rotationPlatform.setPositionDriven();
    }

    public UpdateStrategy.PositionDriven getPositionDriven() {
        return this.rotationPlatform.getPositionDriven();
    }

    public UpdateStrategy getVelocityDriven() {
        return this.rotationPlatform.getVelocityDriven();
    }

    public UpdateStrategy getAccelDriven() {
        return this.rotationPlatform.getAccelDriven();
    }

    public static TimeSeriesFactory getTimeSeriesFactory() {
        return timeSeriesFactory;
    }

    public void startRecording() {
        this.getTimeSeriesModel().startRecording();
    }
}

