/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.rotation.MyRepaintManager;
import java.util.ArrayList;

public class RotationClock
extends ConstantDtClock {
    private ArrayList tickTimes = new ArrayList();
    private static ArrayList clocks = new ArrayList();

    public RotationClock() {
        super(50, 0.025);
        clocks.add(this);
        this.addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                RotationClock.this.updateRepaintManager();
            }

            public void clockPaused(ClockEvent clockEvent) {
                RotationClock.this.updateRepaintManager();
            }
        });
    }

    private void updateRepaintManager() {
        MyRepaintManager.getInstance().setDoMyCoalesce(this.getRunningClocks() > 0);
    }

    protected void doTick() {
        this.tickTimes.add(new Long(System.currentTimeMillis()));
        if (this.tickTimes.size() > 100) {
            this.tickTimes.remove(0);
        }
        super.doTick();
        MyRepaintManager.getInstance().doUpdateNow();
    }

    public int getRunningClocks() {
        int n = 0;
        for (int i = 0; i < clocks.size(); ++i) {
            RotationClock rotationClock = (RotationClock)clocks.get(i);
            if (!rotationClock.isRunning()) continue;
            ++n;
        }
        return n;
    }
}

