/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import JSci.maths.LinearMath;
import JSci.maths.vectors.AbstractDoubleVector;
import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.rotation.RotationResources;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.model.RotationTemporalVariable;
import edu.colorado.phet.rotation.tests.CircularRegression;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class RotationBody {
    private MotionBody xBody;
    private MotionBody yBody;
    private UpdateStrategy updateStrategy = new OffPlatform();
    private ITemporalVariable speed;
    private ITemporalVariable accelMagnitude;
    private ITemporalVariable angle;
    private ITemporalVariable angularVelocity;
    private ITemporalVariable angularAccel;
    private ITemporalVariable orientation;
    private String imageName;
    private boolean constrained;
    private boolean debug;
    private RotationPlatform rotationPlatform;
    private boolean displayGraph = true;
    private CircularRegression.Circle circle;
    private CircularRegression circularRegression = new CircularRegression();
    private CircleDiscriminant circleDiscriminant = new DefaultCircleDiscriminant();
    private double lastNonZeroRadiusAngle = 0.0;
    private ArrayList listeners = new ArrayList();
    private RotationPlatform.Listener listener;
    private double relAngleOnPlatform = 0.0;
    static final Random random = new Random();

    public RotationBody() {
        this("ladybug.gif");
    }

    public RotationBody(String string) {
        this(string, false);
    }

    public RotationBody(String string, boolean bl) {
        this(string, bl, false);
    }

    public RotationBody(String string, boolean bl, boolean bl2) {
        this.imageName = string;
        this.constrained = bl;
        this.debug = bl2;
        this.listener = new RotationPlatform.Adapter(){

            public void innerRadiusChanged() {
                RotationBody.this.platformInnerRadiusChanged();
            }

            public void radiusChanged() {
                RotationBody.this.platformOuterRadiusChanged();
            }
        };
        this.xBody = new MotionBody(RotationModel.getTimeSeriesFactory());
        this.yBody = new MotionBody(RotationModel.getTimeSeriesFactory());
        this.speed = new RotationTemporalVariable();
        this.accelMagnitude = new RotationTemporalVariable();
        this.angle = new RotationTemporalVariable();
        this.angularVelocity = new RotationTemporalVariable();
        this.angularAccel = new RotationTemporalVariable();
        this.orientation = new RotationTemporalVariable();
    }

    public void clearVelocityAndAcceleration() {
        this.getVx().setValue(0.0);
        this.getVy().setValue(0.0);
        this.getAccelX().setValue(0.0);
        this.getAccelY().setValue(0.0);
        this.getAccelMagnitude().setValue(0.0);
    }

    public void clearWindingNumber() {
        this.angle.setValue(this.getAngleNoWindingNumber());
    }

    public void clearAngularVelocity() {
        this.angularVelocity.setValue(0.0);
    }

    private void platformDimensionChanged(DoubleComparator doubleComparator, DoubleNumber doubleNumber) {
        if (this.rotationPlatform != null && doubleComparator.compare(this.getPosition().distance(this.rotationPlatform.getCenter()), doubleNumber.getValue())) {
            if (doubleNumber.getValue() == 0.0) {
                this.setPosition(this.rotationPlatform.getCenter());
            } else {
                AbstractVector2D abstractVector2D = new Vector2D.Double(this.getX() - this.rotationPlatform.getCenter().getX(), this.getY() - this.rotationPlatform.getCenter().getY());
                if (abstractVector2D.getMagnitudeSq() == 0.0) {
                    abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(1.0, this.lastNonZeroRadiusAngle);
                }
                AbstractVector2D abstractVector2D2 = abstractVector2D.getInstanceOfMagnitude(doubleNumber.getValue());
                this.setPosition(abstractVector2D2.getX() + this.rotationPlatform.getCenter().getX(), abstractVector2D2.getY() + this.rotationPlatform.getCenter().getY());
            }
        }
    }

    private void platformInnerRadiusChanged() {
        this.platformDimensionChanged(new DoubleComparator(){

            public boolean compare(double d, double d2) {
                return d < d2;
            }
        }, new DoubleNumber(){

            public double getValue() {
                return RotationBody.this.rotationPlatform.getInnerRadius();
            }
        });
    }

    private void platformOuterRadiusChanged() {
        this.platformDimensionChanged(new DoubleComparator(){

            public boolean compare(double d, double d2) {
                return d > d2;
            }
        }, new DoubleNumber(){

            public double getValue() {
                return RotationBody.this.rotationPlatform.getRadius();
            }
        });
    }

    public void setOffPlatform() {
        if (!this.isOffPlatform()) {
            this.setUpdateStrategy(new OffPlatform());
            this.rotationPlatform = null;
            this.notifyPlatformStateChanged();
        }
    }

    private void notifyPlatformStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).platformStateChanged();
        }
    }

    private void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy.detach();
        this.updateStrategy = updateStrategy;
    }

    public void setOnPlatform(RotationPlatform rotationPlatform) {
        if (this.rotationPlatform != null && rotationPlatform != this.rotationPlatform) {
            this.rotationPlatform.removeListener(this.listener);
        }
        if (!this.isOnPlatform(rotationPlatform)) {
            this.setUpdateStrategy(new OnPlatform(rotationPlatform));
            this.rotationPlatform = rotationPlatform;
            this.rotationPlatform.addListener(this.listener);
            this.relAngleOnPlatform = this.angle.getValue() - rotationPlatform.getPosition();
            this.notifyPlatformStateChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void translate(double d, double d2) {
        this.setPosition(this.getPosition().getX() + d, this.getPosition().getY() + d2);
    }

    public double getOrientation() {
        return this.orientation.getValue();
    }

    public double getX() {
        return this.xBody.getPosition();
    }

    public double getY() {
        return this.yBody.getPosition();
    }

    public double getAngleOverPlatform() {
        return new Vector2D.Double(this.rotationPlatform.getCenter(), this.getPosition()).getAngle();
    }

    public void stepInTime(double d, double d2) {
        if (this.debug) {
            System.out.println("Stepped: x=" + this.getPositionX());
        }
        Point2D point2D = this.getPosition();
        this.updateStrategy.stepInTime(d, d2);
        if (!this.getPosition().equals(point2D)) {
            this.notifyPositionChanged();
        }
        this.speed.addValue(this.getVelocity().getMagnitude(), d);
        this.accelMagnitude.addValue(this.getAcceleration().getMagnitude(), d);
        this.orientation.addValue(this.getOrientation(), d);
        this.notifyVectorsUpdated();
    }

    public void clear() {
        this.xBody.clear();
        this.yBody.clear();
        this.speed.clear();
        this.accelMagnitude.setValue(0.0);
        this.accelMagnitude.clear();
        this.angle.clear();
        this.orientation.clear();
        this.angularVelocity.clear();
        this.angularAccel.clear();
    }

    private void updateOffPlatform(double d) {
        Vector2D vector2D = this.getAcceleration();
        this.xBody.addPositionData(this.xBody.getPosition(), d);
        this.yBody.addPositionData(this.yBody.getPosition(), d);
        int n = 6;
        TimeData timeData = MotionMath.getDerivative(this.xBody.getRecentPositionTimeSeries(Math.min(n, this.xBody.getPositionSampleCount())));
        this.xBody.addVelocityData(timeData.getValue(), timeData.getTime());
        TimeData timeData2 = MotionMath.getDerivative(this.yBody.getRecentPositionTimeSeries(Math.min(n, this.yBody.getPositionSampleCount())));
        this.yBody.addVelocityData(timeData2.getValue(), timeData2.getTime());
        Point2D[] point2DArray = this.getPointHistory(25);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2DArray[0].getX(), point2DArray[0].getY(), 0.0, 0.0);
        for (int i = 1; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            double_.add(point2D);
        }
        if (double_.getWidth() <= 0.2 && double_.getHeight() <= 0.2) {
            this.updateAccelByDerivative();
        } else {
            this.circle = this.circularRegression.getCircle(point2DArray, 50, this.circle);
            if (this.circle.getRadius() > 5.0) {
                this.circle = this.circularRegression.getCircle(point2DArray, 50, null);
            }
            if (this.circleDiscriminant.isCircularMotion(this.circle, point2DArray)) {
                AbstractVector2D abstractVector2D = new Vector2D.Double(new Point2D.Double(this.xBody.getPosition(), this.yBody.getPosition()), this.circle.getCenter2D());
                double d2 = (timeData.getValue() * timeData.getValue() + timeData2.getValue() * timeData2.getValue()) / this.circle.getRadius();
                if (abstractVector2D.getMagnitude() < 0.1) {
                    abstractVector2D = new Vector2D.Double(0.1, 0.1);
                }
                abstractVector2D = abstractVector2D.getInstanceOfMagnitude(d2);
                abstractVector2D = vector2D.getAddedInstance(abstractVector2D).getScaledInstance(0.5);
                this.xBody.addAccelerationData(abstractVector2D.getX(), d);
                this.yBody.addAccelerationData(abstractVector2D.getY(), d);
            } else {
                this.updateAccelByDerivative();
            }
        }
        this.angle.addValue(this.getUserSetAngle(), d);
        TimeData timeData3 = MotionMath.getDerivative(MotionMath.smooth(this.angle.getRecentSeries(Math.min(n, this.angle.getSampleCount())), 4));
        this.angularVelocity.addValue(timeData3.getValue(), timeData3.getTime());
        TimeData timeData4 = MotionMath.getDerivative(MotionMath.smooth(this.angularVelocity.getRecentSeries(Math.min(n, this.angularVelocity.getSampleCount())), 4));
        this.angularAccel.addValue(timeData4.getValue(), timeData4.getTime());
    }

    private double getUserSetAngle() {
        return this.getLastAngle() + this.getDTheta();
    }

    private double getLastAngle() {
        return this.angle.getValue();
    }

    private double getDTheta() {
        double d = this.getAngleNoWindingNumber();
        double d2 = this.getLastAngle();
        AbstractVector2D abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(1.0, d2);
        double d3 = d - (d2 = abstractVector2D.getAngle());
        if (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        } else if (d3 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    private double getAngleNoWindingNumber() {
        return new Vector2D.Double(this.getX(), this.getY()).getAngle();
    }

    private void updateAccelByDerivative() {
        int n = 6;
        TimeData timeData = MotionMath.getDerivative(this.xBody.getRecentVelocityTimeSeries(Math.min(n, this.xBody.getVelocitySampleCount())));
        this.xBody.addAccelerationData(timeData.getValue(), timeData.getTime());
        TimeData timeData2 = MotionMath.getDerivative(this.yBody.getRecentVelocityTimeSeries(Math.min(n, this.yBody.getVelocitySampleCount())));
        this.yBody.addAccelerationData(timeData2.getValue(), timeData2.getTime());
    }

    private static double getLinearRegressionMSE(Point2D[] point2DArray) {
        double[][] dArray = new double[2][point2DArray.length];
        for (int i = 0; i < dArray[0].length; ++i) {
            dArray[0][i] = point2DArray[i].getX();
            dArray[1][i] = point2DArray[i].getY();
        }
        AbstractDoubleVector abstractDoubleVector = LinearMath.linearRegression(dArray);
        double d = abstractDoubleVector.getComponent(0);
        double d2 = abstractDoubleVector.getComponent(1);
        double d3 = 0.0;
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            double d4 = d + d2 * point2D.getX();
            double d5 = point2D.getY();
            d3 += (d4 - d5) * (d4 - d5);
        }
        return d3 / (double)point2DArray.length;
    }

    public CircularRegression.Circle getCircle() {
        return this.circle;
    }

    public Point2D[] getPointHistory(int n) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(n);
        for (int i = 0; i < this.xBody.getPositionVariable().getSampleCount() && i < n; ++i) {
            arrayList.add(new Point2D.Double(this.xBody.getPositionVariable().getRecentData(i).getValue(), this.yBody.getPositionVariable().getRecentData(i).getValue()));
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new Point2D.Double[0]);
    }

    public boolean isOnPlatform() {
        return this.updateStrategy instanceof OnPlatform;
    }

    private boolean isOnPlatform(RotationPlatform rotationPlatform) {
        if (this.updateStrategy instanceof OnPlatform) {
            OnPlatform onPlatform = (OnPlatform)this.updateStrategy;
            return onPlatform.rotationPlatform == rotationPlatform;
        }
        return false;
    }

    private boolean isOffPlatform() {
        return this.updateStrategy instanceof OffPlatform;
    }

    private void notifyVectorsUpdated() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.speedAndAccelerationUpdated();
        }
    }

    private void updateOnPlatform(double d) {
        String[] stringArray;
        boolean bl;
        double d2 = this.rotationPlatform.getVelocity();
        double d3 = this.getPosition().distance(this.rotationPlatform.getCenter());
        boolean bl2 = this.rotationPlatform.getCenter().equals(this.getPosition()) || d3 < 1.0E-6;
        Point2D point2D = bl2 ? new Point2D.Double(this.rotationPlatform.getCenter().getX(), this.rotationPlatform.getCenter().getY()) : Vector2D.Double.parseAngleAndMagnitude(d3, this.getAngleOverPlatform()).getDestination(this.rotationPlatform.getCenter());
        Vector2D.Double double_ = new Vector2D.Double(point2D, this.rotationPlatform.getCenter());
        Vector2D.Double double_2 = bl2 ? this.zero() : double_.getInstanceOfMagnitude(d3 * d2).getNormalVector();
        AbstractVector2D abstractVector2D = bl2 ? this.zero() : double_.getInstanceOfMagnitude(d3 * d2 * d2);
        boolean bl3 = !bl2 && (this.rotationPlatform.isAccelDriven() || this.rotationPlatform.isForceDriven());
        boolean bl4 = bl = !bl2 && this.rotationPlatform.isPositionDriven();
        if (bl3) {
            stringArray = double_.getInstanceOfMagnitude(d3 * this.rotationPlatform.getAcceleration()).getNormalVector();
            abstractVector2D = abstractVector2D.getAddedInstance((AbstractVector2D)stringArray);
        } else if (bl) {
            double d4 = this.rotationPlatform.getAccelerationVariable().estimateAverage(2);
            AbstractVector2D abstractVector2D2 = double_.getInstanceOfMagnitude(d3 * d4).getNormalVector();
            abstractVector2D = abstractVector2D.getAddedInstance(abstractVector2D2);
        }
        this.addPositionData(point2D, d);
        this.addVelocityData(double_2, d);
        this.addAccelerationData(abstractVector2D, d);
        this.angle.addValue(this.rotationPlatform.getPosition() + this.relAngleOnPlatform, this.rotationPlatform.getRecentPositionTimeSeries(1)[0].getTime());
        this.angularVelocity.addValue(this.rotationPlatform.getVelocity(), this.rotationPlatform.getRecentVelocityTimeSeries(1)[0].getTime());
        this.angularAccel.addValue(this.rotationPlatform.getAcceleration(), this.rotationPlatform.getRecentAccelerationTimeSeries(1)[0].getTime());
        this.checkCentripetalAccel();
        if (d3 > 0.0) {
            this.lastNonZeroRadiusAngle = this.getAngleOverPlatform();
        }
        if (double_2.getMagnitude() > 63.0) {
            this.setUpdateStrategy(new FlyingOff(double_2));
            stringArray = new String[]{"whee5", "whoah-7", "words2"};
            RotationResources.getInstance().getAudioClip(stringArray[random.nextInt(stringArray.length)] + ".wav").play();
        }
    }

    private Vector2D.Double zero() {
        return new Vector2D.Double(0.0, 0.0);
    }

    public void checkCentripetalAccel() {
        if (this.rotationPlatform == null) {
            return;
        }
        Vector2D.Double double_ = new Vector2D.Double(this.getPosition(), this.rotationPlatform.getCenter());
        Vector2D vector2D = this.getAcceleration();
        double d = double_.getAngle() - vector2D.getAngle();
        if (Math.abs(d) > 0.01 & vector2D.getMagnitude() > 1.0E-9) {
            // empty if block
        }
    }

    private void addAccelerationData(AbstractVector2D abstractVector2D, double d) {
        this.xBody.addAccelerationData(abstractVector2D.getX(), d);
        this.yBody.addAccelerationData(abstractVector2D.getY(), d);
    }

    private void addVelocityData(AbstractVector2D abstractVector2D, double d) {
        this.xBody.addVelocityData(abstractVector2D.getX(), d);
        this.yBody.addVelocityData(abstractVector2D.getY(), d);
    }

    private void addPositionData(Point2D point2D, double d) {
        this.xBody.addPositionData(point2D.getX(), d);
        this.yBody.addPositionData(point2D.getY(), d);
    }

    public Vector2D getAcceleration() {
        return new Vector2D.Double(this.xBody.getAcceleration(), this.yBody.getAcceleration());
    }

    public Vector2D getVelocity() {
        return new Vector2D.Double(this.xBody.getVelocity(), this.yBody.getVelocity());
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setTime(double d) {
        this.xBody.setTime(d);
        this.yBody.setTime(d);
        this.accelMagnitude.setPlaybackTime(d);
        this.speed.setPlaybackTime(d);
        this.orientation.setPlaybackTime(d);
        if (this.angle.getSampleCount() > 0) {
            this.angle.setPlaybackTime(d);
        }
        if (this.angularVelocity.getSampleCount() > 0) {
            this.angularVelocity.setPlaybackTime(d);
        }
        if (this.angularAccel.getSampleCount() > 0) {
            this.angularAccel.setPlaybackTime(d);
        }
        this.notifyVectorsUpdated();
        this.notifyPositionChanged();
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setDisplayGraph(boolean bl) {
        if (this.displayGraph != bl) {
            this.displayGraph = bl;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).displayGraphChanged();
            }
        }
    }

    public boolean getDisplayGraph() {
        return this.displayGraph;
    }

    public ITemporalVariable getAccelMagnitude() {
        return this.accelMagnitude;
    }

    public ITemporalVariable getAccelX() {
        return this.xBody.getAccelerationVariable();
    }

    public ITemporalVariable getAccelY() {
        return this.yBody.getAccelerationVariable();
    }

    public ITemporalVariable getSpeed() {
        return this.speed;
    }

    public ITemporalVariable getVx() {
        return this.xBody.getVelocityVariable();
    }

    public ITemporalVariable getVy() {
        return this.yBody.getVelocityVariable();
    }

    public ITemporalVariable getPositionX() {
        return this.xBody.getPositionVariable();
    }

    public ITemporalVariable getPositionY() {
        return this.yBody.getPositionVariable();
    }

    public ITemporalVariable getAngularAcceleration() {
        return this.angularAccel;
    }

    public ITemporalVariable getAngularVelocity() {
        return this.angularVelocity;
    }

    public ITemporalVariable getAngle() {
        return this.angle;
    }

    private static Point2D rotate(Point2D point2D, Point2D point2D2, double d) {
        Vector2D.Double double_ = new Vector2D.Double(point2D2, point2D);
        double_.rotate(d);
        return double_.getDestination(point2D2);
    }

    private static Line2D rotate(Line2D line2D, Point2D point2D, double d) {
        return new Line2D.Double(RotationBody.rotate(line2D.getP1(), point2D, d), RotationBody.rotate(line2D.getP2(), point2D, d));
    }

    private void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setOrientation(double d) {
        this.orientation.setValue(d);
        this.notifyOrientationChanged();
    }

    private void notifyOrientationChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).orientationChanged();
        }
    }

    private void notifyPositionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).positionChanged();
        }
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public void setPosition(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("x=" + d + ", y=" + d2);
        }
        if (this.getX() != d || this.getY() != d2) {
            this.xBody.setPosition(d);
            this.yBody.setPosition(d2);
            this.updateAngleValue();
            this.notifyPositionChanged();
        }
    }

    private void updateAngleValue() {
        this.angle.setValue(this.getUserSetAngle());
    }

    private class FlyingOff
    extends UpdateStrategy {
        private AbstractVector2D velocity;

        public FlyingOff(AbstractVector2D abstractVector2D) {
            this.velocity = abstractVector2D;
        }

        public void detach() {
        }

        public void stepInTime(double d, double d2) {
            double d3 = 4.5;
            if (RotationBody.this.getPosition().distance(0.0, 0.0) > d3) {
                this.velocity = new Vector2D.Double(0.0, 0.0);
                Vector2D.Double double_ = new Vector2D.Double(RotationBody.this.xBody.getPosition(), RotationBody.this.yBody.getPosition());
                AbstractVector2D abstractVector2D = double_.getInstanceOfMagnitude(d3);
                RotationBody.this.xBody.setPosition(abstractVector2D.getX());
                RotationBody.this.yBody.setPosition(abstractVector2D.getY());
            }
            RotationBody.this.xBody.addPositionData(RotationBody.this.xBody.getPosition() + this.velocity.getX() * d2, d);
            RotationBody.this.yBody.addPositionData(RotationBody.this.yBody.getPosition() + this.velocity.getY() * d2, d);
            RotationBody.this.xBody.addVelocityData(this.velocity.getX(), d);
            RotationBody.this.yBody.addVelocityData(this.velocity.getY(), d);
            RotationBody.this.xBody.addAccelerationData(0.0, d);
            RotationBody.this.yBody.addAccelerationData(0.0, d);
            RotationBody.this.angle.addValue(RotationBody.this.getUserSetAngle(), d);
            RotationBody.this.angularVelocity.addValue(0.0, d);
            RotationBody.this.angularAccel.addValue(0.0, d);
        }
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void speedAndAccelerationUpdated() {
        }

        public void platformStateChanged() {
        }

        public void displayGraphChanged() {
        }

        public void orientationChanged() {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void speedAndAccelerationUpdated();

        public void platformStateChanged();

        public void displayGraphChanged();

        public void orientationChanged();
    }

    private class OnPlatform
    extends UpdateStrategy
    implements IVariable.Listener {
        private RotationPlatform rotationPlatform;
        private double prevAngle;

        public OnPlatform(RotationPlatform rotationPlatform) {
            this.rotationPlatform = rotationPlatform;
            rotationPlatform.getPositionVariable().addListener(this);
            this.prevAngle = rotationPlatform.getPosition();
        }

        private void positionChanged(double d) {
            Line2D.Double double_ = new Line2D.Double(RotationBody.this.getPosition(), Vector2D.Double.parseAngleAndMagnitude(0.01, RotationBody.this.getOrientation()).getDestination(RotationBody.this.getPosition()));
            RotationBody.this.setPosition(RotationBody.rotate(RotationBody.this.getPosition(), this.rotationPlatform.getCenter(), d));
            Line2D line2D = RotationBody.rotate(double_, this.rotationPlatform.getCenter(), d);
            RotationBody.this.setOrientation(new Vector2D.Double(line2D.getP1(), line2D.getP2()).getAngle());
            RotationBody.this.notifyPositionChanged();
        }

        public void detach() {
            this.rotationPlatform.getPositionVariable().removeListener(this);
        }

        public void stepInTime(double d, double d2) {
            RotationBody.this.updateOnPlatform(d);
        }

        public void valueChanged() {
            this.positionChanged(this.rotationPlatform.getPosition() - this.prevAngle);
            this.prevAngle = this.rotationPlatform.getPosition();
        }
    }

    private class OffPlatform
    extends UpdateStrategy {
        private OffPlatform() {
        }

        public void detach() {
        }

        public void stepInTime(double d, double d2) {
            RotationBody.this.updateOffPlatform(d);
        }
    }

    private static abstract class UpdateStrategy
    implements Serializable {
        private UpdateStrategy() {
        }

        public abstract void detach();

        public abstract void stepInTime(double var1, double var3);
    }

    public static class DefaultCircleDiscriminant
    implements CircleDiscriminant {
        double noncircularMotionMSE = 0.15;
        double thresholdCircularMSE = 1.0;

        public boolean isCircularMotion(CircularRegression.Circle circle, Point2D[] point2DArray) {
            boolean bl = circle.getRadius() >= 0.5;
            boolean bl2 = circle.getRadius() <= 5.0;
            double d = circle.getMeanSquaredError(point2DArray);
            boolean bl3 = d < this.thresholdCircularMSE;
            boolean bl4 = RotationBody.getLinearRegressionMSE(point2DArray) > 0.01;
            return bl && bl2 && bl3 && bl4;
        }
    }

    public static interface CircleDiscriminant {
        public boolean isCircularMotion(CircularRegression.Circle var1, Point2D[] var2);
    }

    static interface DoubleNumber {
        public double getValue();
    }

    static interface DoubleComparator {
        public boolean compare(double var1, double var3);
    }
}

