/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlSeriesNode;
import edu.colorado.phet.common.motion.graphs.GraphControlTextBox;
import edu.colorado.phet.common.motion.graphs.GraphTimeControlNode;
import edu.colorado.phet.common.motion.graphs.ReadoutTitleNode;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.rotation.graphs.RotationGraph;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.model.RotationPlatform;

public class AngularUnitGraph
extends RotationGraph {
    private AngleUnitModel angleUnitModel;
    private String unitsRad;
    private String unitsDeg;
    private double minRad;
    private double maxRad;

    public AngularUnitGraph(PhetPCanvas phetPCanvas, ControlGraphSeries controlGraphSeries, String string, String string2, AngleUnitModel angleUnitModel, String string3, String string4, double d, double d2, RotationModel rotationModel, boolean bl, TimeSeriesModel timeSeriesModel, UpdateStrategy updateStrategy, double d3, RotationPlatform rotationPlatform) {
        super(phetPCanvas, controlGraphSeries, string, string2, string3, d, d2, bl, timeSeriesModel, updateStrategy, d3, rotationPlatform);
        this.angleUnitModel = angleUnitModel;
        this.unitsRad = string3;
        this.unitsDeg = string4;
        this.minRad = d;
        this.maxRad = d2;
        angleUnitModel.addListener(new AngleUnitModel.Listener(){

            public void changed() {
                AngularUnitGraph.this.updateUnits();
            }
        });
        this.updateUnits();
    }

    public void addSeries(ControlGraphSeries controlGraphSeries) {
        super.addSeries(controlGraphSeries);
        controlGraphSeries.setUnits(this.getUnitsString());
    }

    public void resetRange() {
        this.setVerticalRange(this.getDisplayValue(this.getDefaultMinY()), this.getDisplayValue(this.getDefaultMaxY()));
        this.setDomain(0.0, this.getDefaultMaxX());
    }

    private void updateUnits() {
        int n;
        this.getVerticalAxis().setLabel(this.getTitle() + " (" + this.getUnitsString() + ")");
        this.setVerticalRange(this.getDisplayValue(this.minRad), this.getDisplayValue(this.maxRad));
        for (n = 0; n < this.getSeriesCount(); ++n) {
            this.getControlGraphSeries(n).setUnits(this.getUnitsString());
        }
        this.getDynamicJFreeChartNode().clear();
        for (n = 0; n < this.getSeriesCount(); ++n) {
            ControlGraphSeries controlGraphSeries = this.getControlGraphSeries(n);
            for (int i = 0; i < controlGraphSeries.getTemporalVariable().getSampleCount(); ++i) {
                TimeData timeData = controlGraphSeries.getTemporalVariable().getData(i);
                this.getDynamicJFreeChartNode().addValue(this.getSeriesIndex(controlGraphSeries), timeData.getTime(), this.getDisplayValue(timeData));
            }
        }
        this.updateSliderValue();
        this.forceUpdateAll();
    }

    protected GraphTimeControlNode createGraphTimeControlNode(TimeSeriesModel timeSeriesModel) {
        return new AngularGraphTimeControlNode(timeSeriesModel);
    }

    protected ReadoutTitleNode createReadoutTitleNode(ControlGraphSeries controlGraphSeries) {
        return new AngularReadoutTitleNode(controlGraphSeries);
    }

    private double getDisplayValue(double d) {
        return this.isRadians() ? d : this.toDegrees(d);
    }

    private double getDisplayValue(TimeData timeData) {
        return this.getDisplayValue(timeData.getValue());
    }

    protected void handleDataAdded(int n, TimeData timeData) {
        this.addValue(n, timeData.getTime(), this.getDisplayValue(timeData));
    }

    private boolean isRadians() {
        return this.angleUnitModel == null || this.angleUnitModel.isRadians();
    }

    private double toDegrees(double d) {
        return d * 360.0 / 2.0 / Math.PI;
    }

    private double toRadians(double d) {
        return d / 360.0 * 2.0 * Math.PI;
    }

    private String getUnitsString() {
        return this.isRadians() ? this.unitsRad : this.unitsDeg;
    }

    protected void handleValueChanged() {
        this.getSimulationVariable().setValue(this.getModelValue());
    }

    public double getModelValue() {
        return this.viewToModel(this.getSliderValue());
    }

    private double viewToModel(double d) {
        return this.isRadians() ? d : this.toRadians(d);
    }

    protected void updateSliderValue() {
        this.getJFreeChartSliderNode().setValue(this.getDisplayValue(this.getSimulationVariable().getValue()));
    }

    class AngularReadoutTitleNode
    extends ReadoutTitleNode {
        public AngularReadoutTitleNode(ControlGraphSeries controlGraphSeries) {
            super(controlGraphSeries);
        }

        protected double getValueToDisplay() {
            return AngularUnitGraph.this.getDisplayValue(super.getValueToDisplay());
        }
    }

    class AngularGraphControlTextBox
    extends GraphControlTextBox {
        public AngularGraphControlTextBox(ControlGraphSeries controlGraphSeries) {
            super(controlGraphSeries);
            controlGraphSeries.addListener(new ControlGraphSeries.Listener(){

                public void visibilityChanged() {
                }

                public void unitsChanged() {
                    AngularGraphControlTextBox.this.update();
                }
            });
        }

        protected double getDisplayValue() {
            return AngularUnitGraph.this.getDisplayValue(this.getSimVarValue());
        }

        protected double getModelValue() {
            return AngularUnitGraph.this.viewToModel(super.getTextFieldValue());
        }
    }

    class AngularGraphControlSeriesNode
    extends GraphControlSeriesNode {
        public AngularGraphControlSeriesNode(ControlGraphSeries controlGraphSeries) {
            super(controlGraphSeries);
        }

        protected GraphControlTextBox createGraphControlTextBox(ControlGraphSeries controlGraphSeries) {
            return new AngularGraphControlTextBox(controlGraphSeries);
        }
    }

    class AngularGraphTimeControlNode
    extends GraphTimeControlNode {
        public AngularGraphTimeControlNode(TimeSeriesModel timeSeriesModel) {
            super(timeSeriesModel);
        }

        protected GraphControlSeriesNode createGraphControlSeriesNode(ControlGraphSeries controlGraphSeries) {
            return new AngularGraphControlSeriesNode(controlGraphSeries);
        }
    }
}

