/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.dynamic.DynamicJFreeChartNode;
import edu.colorado.phet.common.motion.graphs.ControlGraph;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.JFreeChartSliderNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.graphs.AbstractRotationGraphSet;
import edu.colorado.phet.rotation.graphs.RotationGraph;
import edu.colorado.phet.rotation.graphs.RotationMinimizableControlGraph;
import edu.colorado.phet.rotation.graphs.SeriesJCheckBox;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.torque.TorqueModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import javax.swing.BorderFactory;
import org.jfree.data.Range;

public class AbstractTorqueGraphSet
extends AbstractRotationGraphSet {
    private TorqueModel tm;
    private final String ANG_MOM = RotationStrings.getString("variable.angular.momentum");
    private final String ANG_MOM_VARNAME = RotationStrings.getString("variable.l");
    private final String MOMENT_OF_INERTIA = RotationStrings.getString("variable.moment.of.inertia");
    private final String MOMENT_OF_INERTIA_VARNAME = RotationStrings.getString("variable.i");
    private final String APPLIED_TORQUE = RotationStrings.getString("variable.applied.torque");
    private final String BRAKE_TORQUE = RotationStrings.getString("variable.brake.torque");
    private final String NET_TORQUE = RotationStrings.getString("variable.net.torque");
    private final String BRAKE_RADIUS = RotationStrings.getString("variable.brake.radius");
    private final String APPLIED_FORCE = RotationStrings.getString("variable.applied.force");
    private final String BRAKE_FORCE = RotationStrings.getString("variable.brake.force");
    private final String NET_FORCE = RotationStrings.getString("variable.net.force");
    private final String UNITS_GENERIC = RotationStrings.getString("units.units");
    private final String TORQUE = RotationStrings.getString("variable.torque");
    private final String APPLIED = RotationStrings.getString("variable.applied");
    private final String BRAKE = RotationStrings.getString("object.brake");
    private final String NET = RotationStrings.getString("variable.net");
    private final String FORCE_RADIUS = RotationStrings.getString("variable.radius.of.force");
    private final String F = RotationStrings.getString("variable.f");
    private final String N = RotationStrings.getString("units.n");
    private final String MOM_INERTIA_UNITS = RotationStrings.getString("units.kg.m.2");
    private final String TORQUE_UNITS = RotationStrings.getString("units.n.mm");
    private final String RADIUS_VARNAME = RotationStrings.getString("variable.r");
    private final String RADIUS_UNITS = RotationStrings.getString("units.mm");
    private final String FORCE = RotationStrings.getString("variable.force");

    public AbstractTorqueGraphSet(PhetPCanvas phetPCanvas, TorqueModel torqueModel, AngleUnitModel angleUnitModel) {
        super(phetPCanvas, torqueModel, angleUnitModel);
        this.tm = torqueModel;
        this.initFinished();
    }

    protected void initFinished() {
        this.addSeriesSelectionPanels();
        this.updateBody1Series();
    }

    protected RotationMinimizableControlGraph createAngMomGraph() {
        PhetPCanvas phetPCanvas = super.getCanvas();
        return new RotationMinimizableControlGraph(this.ANG_MOM_VARNAME, new RotationGraph(phetPCanvas, new ControlGraphSeries(this.ANG_MOM, Color.red, this.ANG_MOM_VARNAME, this.UNITS_GENERIC, new BasicStroke(2.0f), null, this.tm.getAngularMomentumTimeSeries()), this.ANG_MOM_VARNAME, this.ANG_MOM, this.UNITS_GENERIC, -0.1, 0.1, false, this.tm.getTimeSeriesModel(), null, 20.0, this.tm.getRotationPlatform()));
    }

    protected RotationMinimizableControlGraph createMomentGraph() {
        PhetPCanvas phetPCanvas = super.getCanvas();
        return new RotationMinimizableControlGraph(this.MOMENT_OF_INERTIA_VARNAME, new RotationGraph(phetPCanvas, new ControlGraphSeries(this.MOMENT_OF_INERTIA, Color.green, this.MOMENT_OF_INERTIA_VARNAME, this.MOM_INERTIA_UNITS, new BasicStroke(2.0f), null, this.tm.getMomentOfInertiaTimeSeries()), this.MOMENT_OF_INERTIA_VARNAME, this.MOMENT_OF_INERTIA, this.MOM_INERTIA_UNITS, -5.0, 5.0, false, this.tm.getTimeSeriesModel(), null, 20.0, this.tm.getRotationPlatform()));
    }

    protected RotationMinimizableControlGraph createTorqueGraph() {
        PhetPCanvas phetPCanvas = super.getCanvas();
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph("\u03c4", new RotationGraph(phetPCanvas, new ControlGraphSeries(this.APPLIED_TORQUE, Color.blue, "\u03c4", this.TORQUE_UNITS, new BasicStroke(4.0f), this.APPLIED, this.tm.getAppliedTorqueTimeSeries()), "\u03c4", this.TORQUE, this.TORQUE_UNITS, -10.0, 10.0, false, this.tm.getTimeSeriesModel(), null, 20.0, this.tm.getRotationPlatform()));
        ControlGraphSeries controlGraphSeries = new ControlGraphSeries(this.BRAKE_TORQUE, Color.red, "\u03c4", this.TORQUE_UNITS, new BasicStroke(2.0f), this.BRAKE, this.tm.getBrakeTorque(), false);
        rotationMinimizableControlGraph.addSeries(controlGraphSeries);
        ControlGraphSeries controlGraphSeries2 = new ControlGraphSeries(this.NET_TORQUE, Color.black, "\u03c4", this.TORQUE_UNITS, new BasicStroke(2.0f), this.NET, this.tm.getNetTorque(), false);
        rotationMinimizableControlGraph.addSeries(controlGraphSeries2);
        rotationMinimizableControlGraph.addControl(new SeriesSelectionPanel(new ControlGraphSeries[]{controlGraphSeries, controlGraphSeries2}));
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createRadiusGraph() {
        PhetPCanvas phetPCanvas = super.getCanvas();
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph(this.RADIUS_VARNAME, new RotationGraph(phetPCanvas, new ControlGraphSeries(this.FORCE_RADIUS, Color.green, this.RADIUS_VARNAME, this.RADIUS_UNITS, new BasicStroke(2.0f), this.APPLIED, this.tm.getRadiusSeries(), true), this.RADIUS_VARNAME, this.FORCE_RADIUS, this.RADIUS_UNITS, 0.0, 4.5, true, this.tm.getTimeSeriesModel(), this.tm.getForceDriven(), 20.0, this.tm.getRotationPlatform()){

            protected Range getVerticalRange(double d) {
                Range range = super.getVerticalRange(d);
                return new Range(0.0, range.getUpperBound());
            }

            protected JFreeChartSliderNode createSliderNode(PNode pNode, Color color) {
                return new JFreeChartSliderNodeForRadius(this.getDynamicJFreeChartNode(), pNode == null ? new PPath() : pNode, color);
            }

            protected void handleValueChanged() {
                this.notifyValueChanged(this.getModelValue());
            }
        });
        rotationMinimizableControlGraph.getControlGraph().addListener(new ControlGraph.Adapter(){

            public void valueChanged(double d) {
                AbstractTorqueGraphSet.this.tm.setAppliedForceRadius(MathUtil.clamp(AbstractTorqueGraphSet.this.tm.getRotationPlatform().getInnerRadius(), d, AbstractTorqueGraphSet.this.tm.getRotationPlatform().getRadius()));
            }
        });
        rotationMinimizableControlGraph.addSeries(new ControlGraphSeries(this.BRAKE_RADIUS, Color.red, this.RADIUS_VARNAME, this.RADIUS_UNITS, new BasicStroke(3.0f), this.BRAKE, this.tm.getBrakeRadiusSeries(), false));
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createForceGraph() {
        PhetPCanvas phetPCanvas = super.getCanvas();
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph(this.F, new RotationGraph(phetPCanvas, new ControlGraphSeries(this.APPLIED_FORCE, Color.blue, this.F, this.N, new BasicStroke(4.0f), this.APPLIED, this.tm.getAppliedForceVariable(), true), this.F, this.FORCE, this.N, -2.5, 2.5, true, this.tm.getTimeSeriesModel(), this.tm.getForceDriven(), 20.0, this.tm.getRotationPlatform()));
        rotationMinimizableControlGraph.getControlGraph().addListener(new ControlGraph.Adapter(){

            public void valueChanged(double d) {
                AbstractTorqueGraphSet.this.tm.setAppliedForce(AbstractTorqueGraphSet.this.tm.getAppliedForceRadius(), d);
            }
        });
        ControlGraphSeries controlGraphSeries = new ControlGraphSeries(this.BRAKE_FORCE, Color.red, this.F, this.N, new BasicStroke(3.0f), this.BRAKE, this.tm.getBrakeForceMagnitudeVariable(), false);
        rotationMinimizableControlGraph.addSeries(controlGraphSeries);
        ControlGraphSeries controlGraphSeries2 = new ControlGraphSeries(this.NET_FORCE, Color.black, this.F, this.N, new BasicStroke(2.0f), this.NET, this.tm.getNetForce(), false);
        rotationMinimizableControlGraph.getControlGraph().addSeries(controlGraphSeries2);
        rotationMinimizableControlGraph.getControlGraph().addControl(new SeriesSelectionPanel(new ControlGraphSeries[]{controlGraphSeries, controlGraphSeries2}));
        return rotationMinimizableControlGraph;
    }

    private class JFreeChartSliderNodeForRadius
    extends JFreeChartSliderNode {
        public JFreeChartSliderNodeForRadius(DynamicJFreeChartNode dynamicJFreeChartNode, PNode pNode, Color color) {
            super(dynamicJFreeChartNode, pNode, color);
        }

        protected double getMaxRangeValue() {
            return Math.min(4.0, super.getMaxRangeValue());
        }
    }

    public static class SeriesSelectionPanel
    extends VerticalLayoutPanel {
        public SeriesSelectionPanel(ControlGraphSeries[] controlGraphSeriesArray) {
            this.setBorder(BorderFactory.createTitledBorder(RotationStrings.getString("series.selection.title")));
            for (int i = 0; i < controlGraphSeriesArray.length; ++i) {
                this.add(new SeriesJCheckBox(controlGraphSeriesArray[i]));
            }
        }
    }
}

