/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlSeriesNode;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.graphs.ShadowJLabel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.graphs.AngularUnitGraph;
import edu.colorado.phet.rotation.graphs.RotationGraph;
import edu.colorado.phet.rotation.graphs.RotationMinimizableControlGraph;
import edu.colorado.phet.rotation.graphs.RotationSeriesSelectionPanel;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.RotationColorScheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Stroke;

public abstract class AbstractRotationGraphSet
extends GraphSuiteSet {
    private Stroke body0Stroke = new BasicStroke(3.0f, 1, 0, 1.0f);
    private Stroke body1Stroke = new BasicStroke(4.0f, 1, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
    private Stroke platformStroke = new BasicStroke(4.0f, 1, 0, 1.0f);
    private RotationModel model;
    private String ANGLE_UNITS_RAD = RotationStrings.RADIANS;
    private String ANGLE_UNITS_DEG = RotationStrings.DEGREES;
    private static final String ANG_VEL_UNITS_RAD = RotationStrings.ANG_VEL_ABBR;
    private static final String ANG_VEL_UNITS_DEG = RotationStrings.ANG_VEL_DEG_ABBR;
    private static final String ANG_ACC_UNITS_RAD = RotationStrings.ANG_ACC_ABBR;
    private static final String ANG_ACC_UNITS_DEG = RotationStrings.ANG_ACC_DEG_ABBR;
    private static final String POSITION_UNITS = RotationStrings.MM_ABBR;
    private static final String VELOCITY_UNITS = RotationStrings.VELOCITY_ABBR;
    private static final String ACCEL_UNITS = RotationStrings.ACCEL_ABBR;
    private static final String CHARACTER_PLATFORM = RotationStrings.getString("object.platform");
    private static final String CHARACTER_LADY = RotationStrings.getString("object.ladybug");
    private static final String CHARACTER_BEETLE = RotationStrings.getString("object.beetle");
    private PhetPCanvas pSwingCanvas;
    private AngleUnitModel angleUnitModel;
    private RotationBody b0;
    private RotationBody b1;
    private static final String ANG_ACCEL = RotationStrings.getString("variable.angular.acceleration");
    private final String ANG_VEL = RotationStrings.getString("variable.angular.velocity");
    private final String ANGLE = RotationStrings.getString("variable.angle");
    private final String PLATFORM_ANG_ACCEL = RotationStrings.getString("variable.platform.ang.accel");

    public AbstractRotationGraphSet(PhetPCanvas phetPCanvas, RotationModel rotationModel, AngleUnitModel angleUnitModel) {
        this.pSwingCanvas = phetPCanvas;
        this.angleUnitModel = angleUnitModel;
        this.model = rotationModel;
        this.b0 = rotationModel.getRotationBody(0);
        this.b1 = rotationModel.getRotationBody(1);
        this.b1.addListener(new RotationBody.Adapter(){

            public void platformStateChanged() {
                AbstractRotationGraphSet.this.updateBody1Series();
            }
        });
        this.updateBody1Series();
    }

    protected RotationMinimizableControlGraph createAGraph() {
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph(RotationStrings.ACCELERATION_ABBR, new RotationGraph(this.pSwingCanvas, null, RotationStrings.twoChar("ax"), RotationStrings.ACCELERATION, ACCEL_UNITS, -16.66666666666667, 16.66666666666667, false, this.model.getTimeSeriesModel(), null, 20.0, null));
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.abs(RotationStrings.ACCELERATION), new ControlGraphSeries(RotationStrings.abs(RotationStrings.ACCELERATION), RotationColorScheme.AM_COLOR, RotationStrings.ACCELERATION_ABBR, ACCEL_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getAccelMagnitude()), new ControlGraphSeries(RotationStrings.abs(RotationStrings.ACCELERATION) + "(2)", this.darken(RotationColorScheme.AM_COLOR), RotationStrings.ACCELERATION_ABBR, ACCEL_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getAccelMagnitude()), this.b0, this.b1);
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.ACCELERATION), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.ACCELERATION), RotationColorScheme.AX_COLOR, RotationStrings.twoChar("ax"), ACCEL_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getAccelX()), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.ACCELERATION) + "(2)", this.darken(RotationColorScheme.AX_COLOR), RotationStrings.twoChar("ax"), ACCEL_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getAccelX()), this.b0, this.b1, false);
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.formatForChart(RotationStrings.Y, RotationStrings.ACCELERATION), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.ACCELERATION), RotationColorScheme.AY_COLOR, RotationStrings.twoChar("ay"), ACCEL_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getAccelY()), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.ACCELERATION) + "(2)", this.darken(RotationColorScheme.AY_COLOR), RotationStrings.twoChar("ay"), ACCEL_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getAccelY()), this.b0, this.b1, false);
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createVGraph() {
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph(RotationStrings.V, new RotationGraph(this.pSwingCanvas, null, RotationStrings.V + "" + RotationStrings.X, RotationStrings.VELOCITY, VELOCITY_UNITS, -15.0, 15.0, false, this.model.getTimeSeriesModel(), null, 20.0, null));
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.SPEED, new ControlGraphSeries(RotationStrings.SPEED, RotationColorScheme.VM_COLOR, RotationStrings.abs(RotationStrings.V), VELOCITY_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getSpeed()), new ControlGraphSeries(RotationStrings.SPEED + "(2)", this.darken(RotationColorScheme.VM_COLOR), RotationStrings.abs(RotationStrings.V), VELOCITY_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getSpeed()), this.b0, this.b1);
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.VELOCITY), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.VELOCITY), RotationColorScheme.VX_COLOR, RotationStrings.twoChar("vx"), VELOCITY_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getVx()), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.VELOCITY) + "(2)", this.darken(RotationColorScheme.VX_COLOR), RotationStrings.twoChar("vx"), VELOCITY_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getVx()), this.b0, this.b1, false);
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.formatForChart(RotationStrings.Y, RotationStrings.VELOCITY), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.Y, RotationStrings.VELOCITY), RotationColorScheme.VY_COLOR, RotationStrings.twoChar("vy"), VELOCITY_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getVy()), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.Y, RotationStrings.VELOCITY) + "(2)", this.darken(RotationColorScheme.VY_COLOR), RotationStrings.twoChar("vy"), VELOCITY_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getVy()), this.b0, this.b1, false);
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createXGraph() {
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph(RotationStrings.X + " & " + RotationStrings.Y, new RotationGraph(this.pSwingCanvas, null, RotationStrings.X, RotationStrings.POSITION, POSITION_UNITS, -5.0, 5.0, false, this.model.getTimeSeriesModel(), null, 20.0, null));
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.POSITION), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.POSITION), RotationColorScheme.X_COLOR, RotationStrings.X, POSITION_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getPositionX()), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.POSITION) + "(2)", this.darken(RotationColorScheme.X_COLOR), RotationStrings.X, POSITION_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getPositionX()), this.b0, this.b1);
        rotationMinimizableControlGraph.addSeriesPair(RotationStrings.formatForChart(RotationStrings.Y, RotationStrings.POSITION), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.Y, RotationStrings.POSITION), RotationColorScheme.Y_COLOR, RotationStrings.Y, POSITION_UNITS, this.body0Stroke, CHARACTER_LADY, this.b0.getPositionY()), new ControlGraphSeries(RotationStrings.formatForChart(RotationStrings.X, RotationStrings.POSITION) + "(2)", this.darken(RotationColorScheme.Y_COLOR), RotationStrings.Y, POSITION_UNITS, this.body1Stroke, CHARACTER_BEETLE, this.b1.getPositionY()), this.b0, this.b1);
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createAngAccelGraph(boolean bl) {
        final ControlGraphSeries controlGraphSeries = new ControlGraphSeries(this.PLATFORM_ANG_ACCEL, RotationColorScheme.ANG_ACC_SUITE.getPlatformColor(), "\u03b1", ANG_ACC_UNITS_RAD, this.platformStroke, CHARACTER_PLATFORM, this.model.getRotationPlatform().getAngularAcceleration(), bl);
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph("\u03b1", new AngularUnitGraph(this.pSwingCanvas, controlGraphSeries, "\u03b1", ANG_ACCEL, this.angleUnitModel, ANG_ACC_UNITS_RAD, ANG_ACC_UNITS_DEG, -1.1, 1.1, this.model, bl, this.model.getTimeSeriesModel(), this.model.getAccelDriven(), 20.0, this.model.getRotationPlatform()));
        rotationMinimizableControlGraph.addSeriesPair(ANG_ACCEL, new ControlGraphSeries(ANG_ACCEL, RotationColorScheme.ANG_ACC_SUITE.getLadybugColor(), "\u03b1", ANG_ACC_UNITS_RAD, this.body0Stroke, CHARACTER_LADY, this.b0.getAngularAcceleration()), new ControlGraphSeries(ANG_ACCEL + "(2) ", RotationColorScheme.ANG_ACC_SUITE.getBeetleColor(), "\u03b1", ANG_ACC_UNITS_RAD, this.body1Stroke, CHARACTER_BEETLE, this.b1.getAngularAcceleration()), this.b0, this.b1);
        this.model.getRotationPlatform().addListener(new RotationPlatform.Adapter(){

            public void displayGraphChanged() {
                controlGraphSeries.setVisible(AbstractRotationGraphSet.this.model.getRotationPlatform().getDisplayGraph());
            }
        });
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createAngVelGraph() {
        final ControlGraphSeries controlGraphSeries = new ControlGraphSeries(this.ANG_VEL, RotationColorScheme.ANG_VEL_SUITE.getPlatformColor(), "\u03c9", ANG_VEL_UNITS_RAD, this.platformStroke, CHARACTER_PLATFORM, this.model.getRotationPlatform().getAngularVelocity(), true);
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph("\u03c9", new AngularUnitGraph(this.pSwingCanvas, controlGraphSeries, "\u03c9", this.ANG_VEL, this.angleUnitModel, ANG_VEL_UNITS_RAD, ANG_VEL_UNITS_DEG, -5.0, 5.0, this.model, true, this.model.getTimeSeriesModel(), this.model.getVelocityDriven(), 20.0, this.model.getRotationPlatform()));
        rotationMinimizableControlGraph.addSeriesPair(this.ANG_VEL, new ControlGraphSeries(this.ANG_VEL, RotationColorScheme.ANG_VEL_SUITE.getLadybugColor(), "\u03c9", ANG_VEL_UNITS_RAD, this.body0Stroke, CHARACTER_LADY, this.b0.getAngularVelocity()), new ControlGraphSeries(this.ANG_VEL + "(2)", RotationColorScheme.ANG_VEL_SUITE.getBeetleColor(), "\u03c9", ANG_VEL_UNITS_RAD, this.body1Stroke, CHARACTER_BEETLE, this.b1.getAngularVelocity()), this.b0, this.b1);
        this.model.getRotationPlatform().addListener(new RotationPlatform.Adapter(){

            public void displayGraphChanged() {
                controlGraphSeries.setVisible(AbstractRotationGraphSet.this.model.getRotationPlatform().getDisplayGraph());
            }
        });
        return rotationMinimizableControlGraph;
    }

    protected RotationMinimizableControlGraph createAngleGraph() {
        final ControlGraphSeries controlGraphSeries = new ControlGraphSeries(this.ANGLE, RotationColorScheme.ANGLE_SUITE.getPlatformColor(), "\u03b8", this.ANGLE_UNITS_RAD, this.platformStroke, CHARACTER_PLATFORM, this.model.getRotationPlatform().getAngle(), true);
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph("\u03b8", new AngularUnitGraph(this.pSwingCanvas, controlGraphSeries, "\u03b8", this.ANGLE, this.angleUnitModel, this.ANGLE_UNITS_RAD, this.ANGLE_UNITS_DEG, Math.PI * -3, Math.PI * 3, this.model, true, this.model.getTimeSeriesModel(), this.model.getPositionDriven(), 20.0, this.model.getRotationPlatform()));
        rotationMinimizableControlGraph.addSeriesPair(this.ANGLE, new ControlGraphSeries(this.ANGLE, RotationColorScheme.ANGLE_SUITE.getLadybugColor(), "\u03b8", this.ANGLE_UNITS_RAD, this.body0Stroke, CHARACTER_LADY, this.b0.getAngle()), new ControlGraphSeries(this.ANGLE + "(2)", RotationColorScheme.ANGLE_SUITE.getBeetleColor(), "\u03b8", this.ANGLE_UNITS_RAD, this.body1Stroke, CHARACTER_BEETLE, this.b1.getAngle()), this.b0, this.b1);
        this.model.getRotationPlatform().addListener(new RotationPlatform.Adapter(){

            public void displayGraphChanged() {
                controlGraphSeries.setVisible(AbstractRotationGraphSet.this.model.getRotationPlatform().getDisplayGraph());
            }
        });
        return rotationMinimizableControlGraph;
    }

    private Color darken(Color color) {
        return this.darken(color, 150);
    }

    private Color darken(Color color, int n) {
        return new Color(Math.max(color.getRed() - n, 0), Math.max(color.getGreen() - n, 0), Math.max(color.getBlue() - n, 0));
    }

    protected void addSeriesSelectionPanels() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            RotationMinimizableControlGraph rotationMinimizableControlGraph = (RotationMinimizableControlGraph)minimizableControlGraphArray[i];
            if (rotationMinimizableControlGraph.getRotationControlGraph().getSeriesPairCount() <= 1) continue;
            VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
            RotationSeriesSelectionPanel rotationSeriesSelectionPanel = new RotationSeriesSelectionPanel(rotationMinimizableControlGraph.getRotationControlGraph());
            ShadowJLabel shadowJLabel = new ShadowJLabel(rotationMinimizableControlGraph.getRotationControlGraph().getTitle(), rotationMinimizableControlGraph.getControlGraph().getControlGraphSeries(0).getColor(), GraphControlSeriesNode.LABEL_FONT);
            ((Container)verticalLayoutPanel).add(shadowJLabel);
            ((Container)verticalLayoutPanel).add(rotationSeriesSelectionPanel);
            minimizableControlGraphArray[i].getControlGraph().addControl(verticalLayoutPanel);
        }
    }

    protected void updateBody1Series() {
        for (int i = 0; i < this.getAllGraphs().length; ++i) {
            RotationMinimizableControlGraph rotationMinimizableControlGraph = (RotationMinimizableControlGraph)this.getAllGraphs()[i];
            ((RotationGraph)rotationMinimizableControlGraph.getControlGraph()).setSecondarySeriesVisible(this.model.getRotationBody(1).isOnPlatform());
        }
    }

    public PhetPCanvas getCanvas() {
        return this.pSwingCanvas;
    }
}

