/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.controls;

import java.util.ArrayList;

public class VectorViewModel {
    private boolean velocityVisible = true;
    private boolean accelerationVisible = true;
    private ArrayList listeners = new ArrayList();

    public VectorViewModel() {
        this.resetAll();
    }

    public boolean isVelocityVisible() {
        return this.velocityVisible;
    }

    public boolean isAccelerationVisible() {
        return this.accelerationVisible;
    }

    public void setVelocityVisible(boolean bl) {
        if (this.velocityVisible != bl) {
            this.velocityVisible = bl;
            this.notifyListeners();
        }
    }

    public void setAccelerationVisible(boolean bl) {
        if (this.accelerationVisible != bl) {
            this.accelerationVisible = bl;
            this.notifyListeners();
        }
    }

    public void resetAll() {
        this.setAccelerationVisible(true);
        this.setVelocityVisible(true);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.visibilityChanged();
        }
    }

    public static interface Listener {
        public void visibilityChanged();
    }
}

