/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.controls;

import edu.colorado.phet.common.phetcommon.view.MultiStateButton;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.controls.SymbolKey;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SymbolKeyButton
extends JPanel {
    private JDialog dialog;
    private String SHOW_MODE = "SHOW";
    private String HIDE_MODE = "HIDE";
    private MultiStateButton button;

    public SymbolKeyButton(JFrame jFrame) {
        this.dialog = new JDialog(jFrame, RotationStrings.getString("controls.symbol.key"), false);
        this.button = new MultiStateButton();
        this.button.addMode(this.SHOW_MODE, RotationStrings.getString("controls.symbol.key"), null);
        this.button.addMode(this.HIDE_MODE, RotationStrings.getString("controls.hide.symbol.key"), null);
        this.button.addActionListener(this.SHOW_MODE, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtils.centerDialogInParent(SymbolKeyButton.this.dialog);
                SymbolKeyButton.this.dialog.show();
                if (SymbolKeyButton.this.dialog.getContentPane() instanceof JComponent) {
                    JComponent jComponent = (JComponent)SymbolKeyButton.this.dialog.getContentPane();
                    jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                }
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SymbolKeyButton.this.button.setMode(SymbolKeyButton.this.SHOW_MODE);
            }
        });
        this.button.addActionListener(this.HIDE_MODE, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SymbolKeyButton.this.dialog.hide();
            }
        });
        this.dialog.setContentPane(new SymbolKey());
        this.dialog.pack();
        this.add(this.button);
    }

    public void reset() {
        this.dialog.hide();
        this.button.setMode(this.SHOW_MODE);
    }
}

