/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.controls;

import edu.colorado.phet.common.motion.graphs.GraphSelectionControl;
import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.rotation.AbstractRotationModule;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.controls.AngleUnitsSelectionControl;
import edu.colorado.phet.rotation.controls.ResetButton;
import edu.colorado.phet.rotation.controls.RulerButton;
import edu.colorado.phet.rotation.controls.ShowVectorsControl;
import edu.colorado.phet.rotation.controls.SymbolKeyButton;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.AngleUnitModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationPlatform;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class RotationControlPanel
extends HorizontalLayoutPanel
implements Resettable {
    private SymbolKeyButton symbolKeyButton;

    public RotationControlPanel(RulerNode rulerNode, GraphSuiteSet graphSuiteSet, GraphSetModel graphSetModel, VectorViewModel vectorViewModel, JFrame jFrame, final RotationBody rotationBody, final RotationBody rotationBody2, AbstractRotationModule abstractRotationModule, AngleUnitModel angleUnitModel, final RotationPlatform rotationPlatform) {
        GraphSelectionControl graphSelectionControl = new GraphSelectionControl(graphSuiteSet, graphSetModel);
        this.symbolKeyButton = new SymbolKeyButton(jFrame);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.add(this.symbolKeyButton);
        final JCheckBox jCheckBox = new JCheckBox(RotationStrings.getString("controls.show.beetle.graph"), rotationBody2.getDisplayGraph());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rotationBody2.setDisplayGraph(jCheckBox.isSelected());
            }
        });
        rotationBody2.addListener(new RotationBody.Adapter(){

            public void displayGraphChanged() {
                jCheckBox.setSelected(rotationBody2.getDisplayGraph());
            }
        });
        rotationBody2.addListener(new RotationBody.Adapter(){

            public void platformStateChanged() {
                if (rotationBody2.isOnPlatform()) {
                    rotationBody2.setDisplayGraph(true);
                }
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox(RotationStrings.getString("controls.show.ladybug.graph"), rotationBody.getDisplayGraph());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rotationBody.setDisplayGraph(jCheckBox2.isSelected());
            }
        });
        rotationBody.addListener(new RotationBody.Adapter(){

            public void displayGraphChanged() {
                jCheckBox2.setSelected(rotationBody.getDisplayGraph());
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox(RotationStrings.getString("controls.show.platform.graph"), rotationPlatform.getDisplayGraph());
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rotationPlatform.setDisplayGraph(jCheckBox3.isSelected());
            }
        });
        verticalLayoutPanel.add(jCheckBox3);
        verticalLayoutPanel.add(jCheckBox2);
        verticalLayoutPanel.add(jCheckBox);
        AngleUnitsSelectionControl angleUnitsSelectionControl = new AngleUnitsSelectionControl(angleUnitModel);
        verticalLayoutPanel.add(angleUnitsSelectionControl);
        verticalLayoutPanel.add(new ResetButton(abstractRotationModule));
        verticalLayoutPanel.add(new RulerButton(rulerNode));
        VerticalLayoutPanel verticalLayoutPanel2 = new VerticalLayoutPanel();
        verticalLayoutPanel2.add(graphSelectionControl);
        verticalLayoutPanel2.add(Box.createRigidArea(new Dimension(30, 30)));
        verticalLayoutPanel2.add(new ShowVectorsControl(vectorViewModel));
        this.add(verticalLayoutPanel2);
        this.add(verticalLayoutPanel);
    }

    public void reset() {
        this.symbolKeyButton.reset();
    }
}

