/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.rotation.MyRepaintManager;
import edu.colorado.phet.rotation.torque.AbstractTorqueModule;
import edu.colorado.phet.rotation.torque.AngularMomentumModule;
import edu.colorado.phet.rotation.torque.MomentOfInertiaModule;
import edu.colorado.phet.rotation.torque.TorqueIntroModule;
import edu.colorado.phet.rotation.torque.TorqueModule;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import javax.swing.RepaintManager;

public class TorqueApplication
extends PiccoloPhetApplication {
    private AbstractTorqueModule torqueModule;
    private TorqueIntroModule introModule = new TorqueIntroModule(this.getPhetFrame());
    private MomentOfInertiaModule momentModule;
    private AngularMomentumModule angMomModule;

    public TorqueApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.torqueModule = new TorqueModule(this.getPhetFrame());
        this.momentModule = new MomentOfInertiaModule(this.getPhetFrame());
        this.angMomModule = new AngularMomentumModule(this.getPhetFrame());
        this.addModule(this.introModule);
        this.addModule(this.torqueModule);
        this.addModule(this.momentModule);
        this.addModule(this.angMomModule);
    }

    public static void main(String[] stringArray) {
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "rotation", "torque");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                MyRepaintManager myRepaintManager = new MyRepaintManager();
                myRepaintManager.setDoMyCoalesce(true);
                RepaintManager.setCurrentManager(myRepaintManager);
                new RotationLookAndFeel().initLookAndFeel();
                return new TorqueApplication(phetApplicationConfig);
            }
        });
    }
}

