/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.rotation.RotationIntroModule;
import edu.colorado.phet.rotation.RotationStrings;
import edu.colorado.phet.rotation.controls.ResetButton;
import edu.colorado.phet.rotation.controls.RulerButton;
import edu.colorado.phet.rotation.controls.ShowVectorsControl;
import edu.colorado.phet.rotation.view.RotationSimPlayAreaNode;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RotationIntroControlPanel
extends VerticalLayoutPanel {
    public RotationIntroControlPanel(RotationIntroModule rotationIntroModule, RotationSimPlayAreaNode rotationSimPlayAreaNode) {
        this.add(new ResetButton(rotationIntroModule));
        this.add(new ShowVectorsControl(rotationIntroModule.getVectorViewModel()));
        RulerButton rulerButton = new RulerButton(rotationSimPlayAreaNode.getRulerNode());
        this.add(rulerButton);
        this.add(this.createAngleSlider(rotationIntroModule));
        this.add(this.createVelocitySlider(rotationIntroModule));
    }

    public static double radiansToDegrees(double d) {
        return d * 360.0 / 2.0 / Math.PI;
    }

    public static double degreesToRadians(double d) {
        return d * Math.PI * 2.0 / 360.0;
    }

    private LinearValueControl createAngleSlider(final RotationIntroModule rotationIntroModule) {
        final LinearValueControl linearValueControl = new LinearValueControl(RotationIntroControlPanel.radiansToDegrees(Math.PI * -4), RotationIntroControlPanel.radiansToDegrees(Math.PI * 4), 0.0, RotationStrings.getString("variable.angle"), "0.00", RotationStrings.getString("units.degrees")){

            protected boolean isValueInRange(double d) {
                return true;
            }
        };
        linearValueControl.getTextField().setColumns("1000.00".length());
        linearValueControl.setSignifyOutOfBounds(false);
        final ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationIntroModule.getRotationModel().getRotationPlatform().setPositionDriven();
                rotationIntroModule.getRotationModel().getRotationPlatform().setPosition(RotationIntroControlPanel.degreesToRadians(linearValueControl.getValue()));
            }
        };
        linearValueControl.addChangeListener(changeListener);
        rotationIntroModule.getRotationModel().getRotationPlatform().getPositionVariable().addListener(new IVariable.Listener(){

            public void valueChanged() {
                linearValueControl.removeChangeListener(changeListener);
                linearValueControl.setValue(RotationIntroControlPanel.radiansToDegrees(rotationIntroModule.getRotationModel().getRotationPlatform().getPositionVariable().getValue()));
                linearValueControl.addChangeListener(changeListener);
            }
        });
        return linearValueControl;
    }

    private LinearValueControl createVelocitySlider(final RotationIntroModule rotationIntroModule) {
        final LinearValueControl linearValueControl = new LinearValueControl(RotationIntroControlPanel.radiansToDegrees(-5.0), RotationIntroControlPanel.radiansToDegrees(5.0), 0.0, RotationStrings.getString("variable.angular.velocity"), "0.00", RotationStrings.getString("units.degrees") + "/" + RotationStrings.getString("units.s")){

            protected boolean isValueInRange(double d) {
                return true;
            }
        };
        linearValueControl.getTextField().setColumns("1000.00".length());
        linearValueControl.setSignifyOutOfBounds(false);
        final ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationIntroModule.getRotationModel().getRotationPlatform().setVelocityDriven();
                rotationIntroModule.getRotationModel().getRotationPlatform().setVelocity(RotationIntroControlPanel.degreesToRadians(linearValueControl.getValue()));
            }
        };
        linearValueControl.addChangeListener(changeListener);
        rotationIntroModule.getRotationModel().getRotationPlatform().getVelocityVariable().addListener(new IVariable.Listener(){

            public void valueChanged() {
                linearValueControl.removeChangeListener(changeListener);
                linearValueControl.setValue(RotationIntroControlPanel.radiansToDegrees(rotationIntroModule.getRotationModel().getRotationPlatform().getVelocityVariable().getValue()));
                linearValueControl.addChangeListener(changeListener);
            }
        });
        return linearValueControl;
    }
}

