/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.rotation.MyRepaintManager;
import edu.colorado.phet.rotation.RotationIntroModule;
import edu.colorado.phet.rotation.RotationModule;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class RotationApplication
extends PiccoloPhetApplication {
    private RotationModule rotationModule;

    public RotationApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        RotationIntroModule rotationIntroModule = new RotationIntroModule(this.getPhetFrame());
        this.addModule(rotationIntroModule);
        this.rotationModule = new RotationModule(this.getPhetFrame());
        this.addModule(this.rotationModule);
        this.getPhetFrame().addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (RotationApplication.this.getPhetFrame().getContentPane() instanceof JComponent) {
                    JComponent jComponent = (JComponent)RotationApplication.this.getPhetFrame().getContentPane();
                    jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                }
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    public void startApplication() {
        this.rotationModule.initFinished();
        super.startApplication();
        this.rotationModule.getRotationSimulationPanel().requestFocus();
        this.rotationModule.startApplication();
    }

    public static void main(String[] stringArray) {
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "rotation");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                MyRepaintManager myRepaintManager = new MyRepaintManager();
                myRepaintManager.setDoMyCoalesce(true);
                RepaintManager.setCurrentManager(myRepaintManager);
                new RotationLookAndFeel().initLookAndFeel();
                return new RotationApplication(phetApplicationConfig);
            }
        });
    }

    public RotationModule getRotationModule() {
        return this.rotationModule;
    }
}

