/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.rotation.MyRepaintManager;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.RotationClock;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.view.AbstractRotationSimulationPanel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class AbstractRotationModule
extends PiccoloModule {
    private AbstractRotationSimulationPanel rotationSimulationPanel;
    private RotationModel rotationModel;
    private VectorViewModel vectorViewModel;
    private boolean clockPaused = true;

    public AbstractRotationModule(String string, JFrame jFrame) {
        super(string, new RotationClock());
        this.setModel(new BaseModel());
        this.setLogoPanel(null);
        this.setClockControlPanel(null);
        this.rotationModel = this.createModel((ConstantDtClock)this.getClock());
        this.vectorViewModel = new VectorViewModel();
        this.rotationSimulationPanel = this.createSimulationPanel(jFrame);
        this.setSimulationPanel(this.rotationSimulationPanel);
        this.getClock().addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                AbstractRotationModule.this.updateRepaintManager();
            }

            public void clockPaused(ClockEvent clockEvent) {
                AbstractRotationModule.this.updateRepaintManager();
            }
        });
        this.updateRepaintManager();
        this.addRepaintOnActivateBehavior();
    }

    protected void updateRepaintManager() {
        if (MyRepaintManager.getInstance() != null) {
            // empty if block
        }
    }

    protected abstract RotationModel createModel(ConstantDtClock var1);

    protected abstract AbstractRotationSimulationPanel createSimulationPanel(JFrame var1);

    public RotationModel getRotationModel() {
        return this.rotationModel;
    }

    public void activate() {
        super.activate();
        if (this.clockPaused) {
            this.getClock().pause();
        } else {
            this.getClock().start();
        }
    }

    public void deactivate() {
        this.clockPaused = this.getClock().isPaused();
        super.deactivate();
    }

    public AbstractRotationSimulationPanel getRotationSimulationPanel() {
        return this.rotationSimulationPanel;
    }

    public void startApplication() {
        this.rotationSimulationPanel.startApplication();
    }

    public void reset() {
        if (this.confirmReset()) {
            super.reset();
            this.rotationModel.resetAll();
            this.rotationSimulationPanel.resetAll();
            this.vectorViewModel.resetAll();
            if (this.getClock() instanceof ConstantDtClock) {
                ConstantDtClock constantDtClock = (ConstantDtClock)this.getClock();
                constantDtClock.setDt(0.025);
            }
            DefaultTimeSeries.verifySeriesCleared();
            this.rotationModel.getTimeSeriesModel().setPaused(true);
        }
    }

    private boolean confirmReset() {
        int n = JOptionPane.showConfirmDialog(this.rotationSimulationPanel, PhetCommonResources.getString("ControlPanel.message.confirmResetAll"));
        return n == 0;
    }

    public VectorViewModel getVectorViewModel() {
        return this.vectorViewModel;
    }

    public void initFinished() {
        this.updateRepaintManager();
    }
}

