/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.FullRepaintCanvas;
import edu.colorado.phet.rotation.view.RotationPlayAreaNode;
import edu.umd.cs.piccolo.PNode;
import javax.swing.JComponent;

public class AbstractIntroSimulationPanel
extends FullRepaintCanvas {
    private RotationPlayAreaNode playAreaNode;
    private PNode introSimControlPanelPSwing;
    private RotationPlatform rotationPlatform;

    public AbstractIntroSimulationPanel(JComponent jComponent, ConstantDtClock constantDtClock, Module module) {
        super(constantDtClock, module);
        this.addKeyListener(new PDebugKeyHandler());
        this.requestFocus();
    }

    protected void init(RotationPlayAreaNode rotationPlayAreaNode, PNode pNode, RotationPlatform rotationPlatform) {
        this.playAreaNode = rotationPlayAreaNode;
        this.introSimControlPanelPSwing = pNode;
        this.rotationPlatform = rotationPlatform;
    }

    protected void updateLayout() {
        int n = 50;
        int n2 = 50;
        this.playAreaNode.setScale(1.0);
        double d = (double)(this.getWidth() - n * 2) / this.playAreaNode.getPlatformNode().getFullBounds().getWidth();
        double d2 = (double)(this.getHeight() - n2 * 2) / this.playAreaNode.getPlatformNode().getFullBounds().getHeight();
        double d3 = Math.min(d, d2);
        if (d3 > 0.0) {
            this.playAreaNode.scale(d3);
        }
        this.playAreaNode.setOffset((double)this.getWidth() * 0.6, d3 * this.getRotationPlatform().getRadius() + (double)(n2 / 2));
        this.introSimControlPanelPSwing.setOffset(0.0, (double)this.getHeight() - this.introSimControlPanelPSwing.getFullBounds().getHeight());
    }

    protected RotationPlatform getRotationPlatform() {
        return this.rotationPlatform;
    }
}

