/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.timeseries.ui;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.timeseries.ui.TimeseriesResources;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;

public class TimeSpeedSlider
extends VerticalLayoutPanel {
    private LinearValueControl linearSlider;

    public TimeSpeedSlider(double d, double d2, String string, ConstantDtClock constantDtClock) {
        this(d, d2, string, constantDtClock, TimeseriesResources.getString("Common.sim.speed"));
    }

    public TimeSpeedSlider(double d, double d2, String string, final ConstantDtClock constantDtClock, String string2) {
        this.linearSlider = new LinearValueControl(d, d2, "", string, "");
        this.linearSlider.setTextFieldVisible(false);
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(d), new JLabel(TimeseriesResources.getString("Common.time.slow")));
        hashtable.put(new Double(d2), new JLabel(TimeseriesResources.getString("Common.time.fast")));
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(new PhetFont(2, PhetFont.getDefaultFontSize()));
        hashtable.put(new Double((d2 + d) / 2.0), jLabel);
        this.linearSlider.setTickLabels(hashtable);
        constantDtClock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                TimeSpeedSlider.this.update(constantDtClock);
            }
        });
        this.update(constantDtClock);
        this.add(this.linearSlider);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.linearSlider.addChangeListener(changeListener);
    }

    private void update(ConstantDtClock constantDtClock) {
        this.linearSlider.setValue(constantDtClock.getTimingStrategy().getSimulationTimeChangeForPausedClock());
    }

    public double getValue() {
        return this.linearSlider.getValue();
    }

    public void setValue(double d) {
        this.linearSlider.setValue(d);
    }
}

