/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.timeseries.model;

import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import java.util.ArrayList;

public abstract class Mode {
    private TimeSeriesModel timeSeriesModel;

    public Mode(TimeSeriesModel timeSeriesModel) {
        this.timeSeriesModel = timeSeriesModel;
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.timeSeriesModel;
    }

    public abstract void step(double var1);

    public static class Record
    extends Mode {
        private double recordTime = 0.0;

        public Record(TimeSeriesModel timeSeriesModel) {
            super(timeSeriesModel);
        }

        public void reset() {
            this.recordTime = 0.0;
        }

        public void step(double d) {
            double d2 = this.recordTime + d;
            double d3 = this.getTimeSeriesModel().getMaxRecordTime();
            if (d2 > d3) {
                d = d3 - this.recordTime;
                d2 = this.getTimeSeriesModel().getMaxRecordTime();
            }
            this.recordTime += d;
            this.getTimeSeriesModel().updateModel(d);
            this.getTimeSeriesModel().addSeriesPoint(this.getTimeSeriesModel().getModelState(), this.recordTime);
            if (d2 == this.getTimeSeriesModel().getMaxRecordTime()) {
                this.getTimeSeriesModel().recordFinished();
            }
        }

        public double getRecordTime() {
            return this.recordTime;
        }
    }

    public static class Playback
    extends Mode {
        private double playbackTime = 0.0;
        private ArrayList listeners = new ArrayList();

        public Playback(TimeSeriesModel timeSeriesModel) {
            super(timeSeriesModel);
        }

        public double getPlaybackTime() {
            return this.playbackTime;
        }

        public void step(double d) {
            this.playbackTime += d;
            this.playbackTime = Math.min(this.getTimeSeriesModel().getRecordTime(), this.playbackTime);
            this.getTimeSeriesModel().setPlaybackTime(this.playbackTime);
            if (this.playbackTime >= this.getTimeSeriesModel().getRecordTime()) {
                this.getTimeSeriesModel().setPaused(true);
            }
            this.notifyPlaybackTimeChanged();
        }

        private void notifyPlaybackTimeChanged() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                TimeSeriesModel.PlaybackTimeListener playbackTimeListener = (TimeSeriesModel.PlaybackTimeListener)this.listeners.get(i);
                playbackTimeListener.timeChanged();
            }
        }

        public void setTime(double d) {
            if (this.playbackTime != d) {
                this.playbackTime = d;
                this.notifyPlaybackTimeChanged();
            }
        }

        public void addListener(TimeSeriesModel.PlaybackTimeListener playbackTimeListener) {
            this.listeners.add(playbackTimeListener);
        }
    }

    public static class Live
    extends Mode {
        private double time = 0.0;

        public Live(TimeSeriesModel timeSeriesModel) {
            super(timeSeriesModel);
        }

        public void step(double d) {
            this.time += d;
            this.getTimeSeriesModel().updateModel(d);
        }

        public double getTime() {
            return this.time;
        }
    }
}

