/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.test.help;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestHelpBalloon
extends PhetApplication {
    private static final int CLOCK_RATE = 25;
    private static final double MODEL_RATE = 1.0;
    private static final HelpBalloon.Attachment DEFAULT_ARROW_TAIL_POSITION = HelpBalloon.TOP_LEFT;
    private static final int DEFAULT_ARROW_LENGTH = 40;
    private static final int DEFAULT_ARROW_ROTATION = 0;
    private static final int MIN_ARROW_ROTATION = -70;
    private static final int MAX_ARROW_ROTATION = 70;

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                try {
                    TestHelpBalloon testHelpBalloon = new TestHelpBalloon(phetApplicationConfig);
                    return testHelpBalloon;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "piccolo-phet");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    public TestHelpBalloon(PhetApplicationConfig phetApplicationConfig) throws InterruptedException {
        super(phetApplicationConfig);
        TestModule testModule = new TestModule("Module 1");
        this.addModule(testModule);
    }

    private static class LabeledSlider
    extends JPanel {
        private JLabel _label;
        private String _format;
        private JSlider _slider;

        public LabeledSlider(String string, int n, int n2, int n3, int n4, int n5) {
            this._format = string;
            this._label = new JLabel();
            this._slider = new JSlider();
            this._slider.setMinimum(n);
            this._slider.setMaximum(n2);
            this._slider.setValue(n3);
            this._slider.setMajorTickSpacing(n4);
            this._slider.setMinorTickSpacing(n5);
            this._slider.setPaintTicks(true);
            this._slider.setPaintLabels(true);
            this._slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    LabeledSlider.this.updateLabel();
                }
            });
            this.updateLabel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
            this.setLayout(easyGridBagLayout);
            easyGridBagLayout.addComponent(this._label, 0, 0);
            easyGridBagLayout.addComponent(this._slider, 1, 0);
        }

        private void updateLabel() {
            int n = this._slider.getValue();
            Object[] objectArray = new Object[]{new Integer(n)};
            String string = MessageFormat.format(this._format, objectArray);
            this._label.setText(string);
        }

        public int getValue() {
            return this._slider.getValue();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this._slider.addChangeListener(changeListener);
        }
    }

    private static class TestModule
    extends PiccoloModule {
        private HelpBalloon _helpBalloon;

        public TestModule(String string) {
            super(string, new TestClock(), true);
            this.setLogoPanel(null);
            this.setClockControlPanel(null);
            final PhetPCanvas phetPCanvas = new PhetPCanvas(new Dimension(1000, 1000));
            this.setSimulationPanel(phetPCanvas);
            PPath pPath = new PPath();
            pPath.setPathToRectangle(0.0f, 0.0f, 75.0f, 75.0f);
            pPath.setPaint(Color.RED);
            pPath.setOffset(0.0, 0.0);
            PText pText = new PText("Drag me");
            pText.setFont(new PhetFont(1, 16));
            pText.setTextPaint(Color.BLACK);
            pText.setOffset(pPath.getWidth() / 2.0 - pText.getWidth() / 2.0, pPath.getHeight() / 2.0 - pText.getHeight() / 2.0);
            PComposite pComposite = new PComposite();
            pComposite.setOffset(150.0, 150.0);
            pComposite.addChild(pPath);
            pComposite.addChild(pText);
            pComposite.addInputEventListener(new PDragEventHandler());
            pComposite.addInputEventListener(new CursorHandler());
            phetPCanvas.getLayer().addChild(pComposite);
            JPanel jPanel = new JPanel();
            JComponent jComponent = new JButton("canvas color...");
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "Canvas color", Color.WHITE);
                    phetPCanvas.setBackground(color);
                }
            });
            jPanel.setBorder(new TitledBorder("Canvas properties"));
            Serializable serializable = new EasyGridBagLayout(jPanel);
            jPanel.setLayout((LayoutManager)((Object)serializable));
            int n = 0;
            ((EasyGridBagLayout)serializable).addComponent(jComponent, n++, 0);
            jComponent = new JPanel();
            serializable = new JButton("text color...");
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "Text color", Color.BLACK);
                    TestModule.this._helpBalloon.setTextColor(color);
                }
            });
            JComponent jComponent2 = new LabeledSlider("font size = {0} points", 8, 24, 12, 16, 1);
            ((LabeledSlider)jComponent2).addChangeListener(new ChangeListener((LabeledSlider)jComponent2){
                private final /* synthetic */ LabeledSlider val$fontSizeSlider;
                {
                    this.val$fontSizeSlider = labeledSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    PhetFont phetFont = new PhetFont(0, this.val$fontSizeSlider.getValue());
                    TestModule.this._helpBalloon.setFont(phetFont);
                }
            });
            JComponent jComponent3 = new LabeledSlider("text margin = {0} pixels", 0, 20, 4, 20, 1);
            ((LabeledSlider)jComponent3).addChangeListener(new ChangeListener((LabeledSlider)jComponent3){
                private final /* synthetic */ LabeledSlider val$marginSlider;
                {
                    this.val$marginSlider = labeledSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setTextMargin(this.val$marginSlider.getValue());
                }
            });
            jComponent.setBorder(new TitledBorder("Text properties"));
            Serializable serializable2 = new EasyGridBagLayout((JPanel)jComponent);
            jComponent.setLayout((LayoutManager)((Object)serializable2));
            int n2 = 0;
            ((EasyGridBagLayout)serializable2).addComponent((Component)serializable, n2++, 0);
            ((EasyGridBagLayout)serializable2).addComponent(jComponent2, n2++, 0);
            ((EasyGridBagLayout)serializable2).addComponent(jComponent3, n2++, 0);
            serializable = new JPanel();
            jComponent2 = new JCheckBox("shadow enabled");
            ((AbstractButton)jComponent2).addChangeListener(new ChangeListener((JCheckBox)jComponent2){
                private final /* synthetic */ JCheckBox val$shadowCheckBox;
                {
                    this.val$shadowCheckBox = jCheckBox;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setShadowTextEnabled(this.val$shadowCheckBox.isSelected());
                }
            });
            jComponent3 = new LabeledSlider("shadow offset = {0} pixels", -5, 5, 1, 5, 1);
            ((LabeledSlider)jComponent3).addChangeListener(new ChangeListener((LabeledSlider)jComponent3){
                private final /* synthetic */ LabeledSlider val$shadowOffsetSlider;
                {
                    this.val$shadowOffsetSlider = labeledSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setShadowTextOffset(this.val$shadowOffsetSlider.getValue());
                }
            });
            serializable2 = new JButton("shadow color...");
            ((AbstractButton)serializable2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "shadow color", Color.RED);
                    TestModule.this._helpBalloon.setShadowTextColor(color);
                }
            });
            ((JComponent)serializable).setBorder(new TitledBorder("Shadow properties"));
            Serializable serializable3 = new EasyGridBagLayout((JPanel)serializable);
            ((Container)serializable).setLayout((LayoutManager)((Object)serializable3));
            int n3 = 0;
            ((EasyGridBagLayout)serializable3).addComponent(jComponent2, n3++, 0);
            ((EasyGridBagLayout)serializable3).addComponent(jComponent3, n3++, 0);
            ((EasyGridBagLayout)serializable3).addComponent((Component)serializable2, n3++, 0);
            jComponent2 = new JPanel();
            jComponent3 = new JCheckBox("visible");
            ((AbstractButton)jComponent3).setSelected(true);
            ((AbstractButton)jComponent3).addActionListener(new ActionListener((JCheckBox)jComponent3){
                private final /* synthetic */ JCheckBox val$visibleCheckBox;
                {
                    this.val$visibleCheckBox = jCheckBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TestModule.this._helpBalloon.setBalloonVisible(this.val$visibleCheckBox.isSelected());
                }
            });
            serializable2 = new JButton("balloon fill color...");
            ((AbstractButton)serializable2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "Balloon fill color", Color.YELLOW);
                    TestModule.this._helpBalloon.setBalloonFillPaint(color);
                }
            });
            serializable3 = new JButton("balloon stroke color...");
            ((AbstractButton)serializable3).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "Balloon stroke color", Color.BLACK);
                    TestModule.this._helpBalloon.setBalloonStrokePaint(color);
                }
            });
            JPanel jPanel2 = new LabeledSlider("balloon stroke width = {0} pixels", 1, 10, 1, 9, 1);
            ((LabeledSlider)jPanel2).addChangeListener(new ChangeListener((LabeledSlider)jPanel2){
                private final /* synthetic */ LabeledSlider val$strokeWidthSlider;
                {
                    this.val$strokeWidthSlider = labeledSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setBalloonStroke(new BasicStroke(this.val$strokeWidthSlider.getValue()));
                }
            });
            Serializable serializable4 = new LabeledSlider("balloon corner radius = {0} pixels", 0, 50, 15, 50, 5);
            ((LabeledSlider)serializable4).addChangeListener(new ChangeListener((LabeledSlider)serializable4){
                private final /* synthetic */ LabeledSlider val$cornerRadiusSlider;
                {
                    this.val$cornerRadiusSlider = labeledSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setBalloonCornerRadius(this.val$cornerRadiusSlider.getValue());
                }
            });
            final LabeledSlider labeledSlider = new LabeledSlider("arrow/balloon spacing = {0} pixels", 0, 10, 0, 10, 1);
            labeledSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setArrowBalloonSpacing(labeledSlider.getValue());
                }
            });
            jComponent2.setBorder(new TitledBorder("Balloon properties"));
            Serializable serializable5 = new EasyGridBagLayout((JPanel)jComponent2);
            jComponent2.setLayout((LayoutManager)((Object)serializable5));
            int n4 = 0;
            ((EasyGridBagLayout)serializable5).addComponent(jComponent3, n4++, 0);
            ((EasyGridBagLayout)serializable5).addComponent((Component)serializable2, n4++, 0);
            ((EasyGridBagLayout)serializable5).addComponent((Component)serializable3, n4++, 0);
            ((EasyGridBagLayout)serializable5).addComponent(jPanel2, n4++, 0);
            ((EasyGridBagLayout)serializable5).addComponent((Component)serializable4, n4++, 0);
            ((EasyGridBagLayout)serializable5).addComponent(labeledSlider, n4++, 0);
            jComponent3 = new JPanel();
            serializable2 = new HelpBalloon.Attachment[]{HelpBalloon.TOP_LEFT, HelpBalloon.TOP_CENTER, HelpBalloon.TOP_RIGHT, HelpBalloon.BOTTOM_LEFT, HelpBalloon.BOTTOM_CENTER, HelpBalloon.BOTTOM_RIGHT, HelpBalloon.LEFT_TOP, HelpBalloon.LEFT_CENTER, HelpBalloon.LEFT_BOTTOM, HelpBalloon.RIGHT_TOP, HelpBalloon.RIGHT_CENTER, HelpBalloon.RIGHT_BOTTOM};
            serializable3 = new JComboBox((E[])serializable2);
            ((Component)serializable3).setCursor(new Cursor(12));
            ((JComboBox)serializable3).setSelectedItem(DEFAULT_ARROW_TAIL_POSITION);
            ((JComboBox)serializable3).setMaximumRowCount(((Serializable)serializable2).length);
            ((JComboBox)serializable3).addItemListener(new ItemListener((JComboBox)serializable3){
                private final /* synthetic */ JComboBox val$tailPositionComboBox;
                {
                    this.val$tailPositionComboBox = jComboBox;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        TestModule.this._helpBalloon.setArrowTailPosition((HelpBalloon.Attachment)this.val$tailPositionComboBox.getSelectedItem());
                    }
                }
            });
            jPanel2 = new JPanel();
            serializable4 = new EasyGridBagLayout(jPanel2);
            jPanel2.setLayout((LayoutManager)((Object)serializable4));
            ((EasyGridBagLayout)serializable4).addComponent(new JLabel("arrow tail position:"), 0, 0);
            ((EasyGridBagLayout)serializable4).addComponent((Component)serializable3, 0, 1);
            labeledSlider = new LabeledSlider("arrow length = {0} pixels", 0, 200, 40, 200, 10);
            labeledSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setArrowLength(labeledSlider.getValue());
                }
            });
            serializable5 = new LabeledSlider("arrow rotation = {0} degrees", -70, 70, 0, 70, 10);
            ((LabeledSlider)serializable5).addChangeListener(new ChangeListener((LabeledSlider)serializable5){
                private final /* synthetic */ LabeledSlider val$rotationSlider;
                {
                    this.val$rotationSlider = labeledSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setArrowRotation(this.val$rotationSlider.getValue());
                }
            });
            final LabeledSlider labeledSlider2 = new LabeledSlider("arrow head width = {0} pixels", 5, 30, 10, 25, 1);
            final LabeledSlider labeledSlider3 = new LabeledSlider("arrow head height = {0} pixels", 5, 30, 10, 25, 1);
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = labeledSlider2.getValue();
                    int n2 = labeledSlider3.getValue();
                    TestModule.this._helpBalloon.setArrowHeadSize(n, n2);
                }
            };
            labeledSlider2.addChangeListener(changeListener);
            labeledSlider3.addChangeListener(changeListener);
            final LabeledSlider labeledSlider4 = new LabeledSlider("arrow tail width = {0} pixels", 1, 30, 5, 29, 1);
            labeledSlider4.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setArrowTailWidth(labeledSlider4.getValue());
                }
            });
            final LabeledSlider labeledSlider5 = new LabeledSlider("arrow stroke width = {0} pixels", 1, 10, 1, 9, 1);
            labeledSlider5.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    TestModule.this._helpBalloon.setArrowStroke(new BasicStroke(labeledSlider5.getValue()));
                }
            });
            JButton jButton = new JButton("arrow fill color...");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "Arrow fill color", Color.YELLOW);
                    TestModule.this._helpBalloon.setArrowFillPaint(color);
                }
            });
            JButton jButton2 = new JButton("arrow stroke color...");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(TestModule.this.getFrame(), "Arrow stroke color", Color.BLACK);
                    TestModule.this._helpBalloon.setArrowStrokePaint(color);
                }
            });
            jComponent3.setBorder(new TitledBorder("Arrow properties"));
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)jComponent3);
            jComponent3.setLayout(easyGridBagLayout);
            int n5 = 0;
            easyGridBagLayout.addComponent(jPanel2, n5++, 0);
            easyGridBagLayout.addComponent(labeledSlider, n5++, 0);
            easyGridBagLayout.addComponent((Component)serializable5, n5++, 0);
            easyGridBagLayout.addComponent(labeledSlider2, n5++, 0);
            easyGridBagLayout.addComponent(labeledSlider3, n5++, 0);
            easyGridBagLayout.addComponent(labeledSlider4, n5++, 0);
            easyGridBagLayout.addComponent(jButton, n5++, 0);
            easyGridBagLayout.addComponent(jButton2, n5++, 0);
            easyGridBagLayout.addComponent(labeledSlider5, n5++, 0);
            serializable2 = new ControlPanel();
            this.setControlPanel((JComponent)serializable2);
            ((ControlPanel)serializable2).addControlFullWidth(jPanel);
            ((ControlPanel)serializable2).addVerticalSpace(20);
            ((ControlPanel)serializable2).addControlFullWidth(jComponent);
            ((ControlPanel)serializable2).addVerticalSpace(20);
            ((ControlPanel)serializable2).addControlFullWidth((Component)serializable);
            ((ControlPanel)serializable2).addVerticalSpace(20);
            ((ControlPanel)serializable2).addControlFullWidth(jComponent2);
            ((ControlPanel)serializable2).addVerticalSpace(20);
            ((ControlPanel)serializable2).addControlFullWidth(jComponent3);
            this.setHelpEnabled(true);
            serializable3 = this.getDefaultHelpPane();
            this._helpBalloon = new HelpBalloon((JComponent)serializable3, "<html>This is a HelpBalloon.<br>Adjust its properties<br>in the control panel</html>", DEFAULT_ARROW_TAIL_POSITION, 40.0, 0.0);
            this._helpBalloon.pointAt(pPath, phetPCanvas);
            ((HelpPane)serializable3).add(this._helpBalloon);
        }

        public boolean hasHelp() {
            return true;
        }

        public JFrame getFrame() {
            return PhetApplication.instance().getPhetFrame();
        }
    }

    private static class TestClock
    extends SwingClock {
        public TestClock() {
            super(40, new TimingStrategy.Constant(1.0));
        }
    }
}

