/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.TimeControlListener;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.ToolTipHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.DefaultIconButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PlayPauseButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.RewindButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.StepButton;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PiccoloTimeControlPanel
extends JPanel {
    private static final String PLAY_TOOLTIP = PhetCommonResources.getString("Common.ClockControlPanel.Play");
    private static final String PAUSE_TOOLTIP = PhetCommonResources.getString("Common.ClockControlPanel.Pause");
    private static final String STEP_TOOLTIP = PhetCommonResources.getString("Common.ClockControlPanel.Step");
    private static final String REWIND_TOOLTIP = PhetCommonResources.getString("Common.ClockControlPanel.Rewind");
    private static final NumberFormat DEFAULT_TIME_FORMAT = new DecimalFormat("0");
    private BackgroundNode backgroundNode;
    private final PlayPauseButton playPauseButton;
    private final StepButton stepButton;
    private final RewindButton rewindButton;
    private JTextField timeTextField;
    private JLabel unitsLabel;
    private JPanel userPanel;
    private ToolTipHandler playPauseTooltipHandler;
    private ToolTipHandler stepTooltipHandler;
    private ToolTipHandler rewindTooltipHandler;
    private NumberFormat timeFormat;
    private double time;
    private boolean paused;
    private ArrayList listeners = new ArrayList();
    private PhetPCanvas buttonCanvas;
    private final ArrayList buttonList;
    private JPanel timeDisplayPanel;

    public PiccoloTimeControlPanel() {
        this.setBorder(null);
        this.setBackground(new JLabel().getBackground());
        this.time = 0.0;
        this.paused = false;
        this.timeFormat = DEFAULT_TIME_FORMAT;
        this.backgroundNode = new BackgroundNode();
        this.playPauseButton = new PlayPauseButton(49);
        this.stepButton = new StepButton((int)(this.playPauseButton.getButtonDimension().width * 0.8));
        this.rewindButton = new RewindButton((int)(this.playPauseButton.getButtonDimension().width * 0.8));
        this.timeTextField = new JTextField();
        this.timeTextField.setColumns(8);
        this.timeTextField.setEditable(false);
        this.timeTextField.setHorizontalAlignment(4);
        this.unitsLabel = new JLabel();
        this.timeDisplayPanel = new JPanel(new FlowLayout(1));
        this.timeDisplayPanel.add(this.timeTextField);
        this.timeDisplayPanel.add(this.unitsLabel);
        SwingUtils.setOpaqueDeep(this.timeDisplayPanel, false);
        this.userPanel = new JPanel(new FlowLayout(1));
        this.userPanel.setOpaque(false);
        this.buttonList = new ArrayList();
        this.buttonCanvas = new PhetPCanvas();
        this.buttonCanvas.setOpaque(false);
        this.buttonCanvas.setBorder(null);
        this.addButton(this.rewindButton);
        this.addButton(this.playPauseButton);
        this.addButton(this.stepButton);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.setOpaque(false);
        jPanel.add(this.buttonCanvas);
        this.setLayout(new FlowLayout(1));
        this.add(this.timeDisplayPanel);
        this.add(this.userPanel);
        this.add(jPanel);
        this.stepTooltipHandler = new ToolTipHandler(STEP_TOOLTIP, this.buttonCanvas);
        this.stepButton.addInputEventListener(this.stepTooltipHandler);
        this.playPauseTooltipHandler = new ToolTipHandler(PAUSE_TOOLTIP, this.buttonCanvas);
        this.playPauseButton.addInputEventListener(this.playPauseTooltipHandler);
        this.rewindTooltipHandler = new ToolTipHandler(REWIND_TOOLTIP, this.buttonCanvas);
        this.rewindButton.addInputEventListener(this.rewindTooltipHandler);
        this.playPauseButton.addListener(new PlayPauseButton.Listener(){

            public void playbackStateChanged() {
                PiccoloTimeControlPanel.this.paused = !PiccoloTimeControlPanel.this.playPauseButton.isPlaying();
                PiccoloTimeControlPanel.this.updateButtons();
                if (PiccoloTimeControlPanel.this.paused) {
                    PiccoloTimeControlPanel.this.notifyPausePressed();
                } else {
                    PiccoloTimeControlPanel.this.notifyPlayPressed();
                }
            }
        });
        this.stepButton.addListener(new DefaultIconButton.Listener(){

            public void buttonPressed() {
                PiccoloTimeControlPanel.this.notifyStepPressed();
            }
        });
        this.rewindButton.addListener(new DefaultIconButton.Listener(){

            public void buttonPressed() {
                PiccoloTimeControlPanel.this.notifyRewindPressed();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PiccoloTimeControlPanel.this.updateButtonLayout();
            }
        });
        this.rewindButton.setVisible(false);
        this.timeDisplayPanel.setVisible(false);
        this.userPanel.setVisible(false);
        this.updateButtons();
        this.updateButtonLayout();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.backgroundNode.fullPaint(new PPaintContext((Graphics2D)graphics));
    }

    private void addButton(PNode pNode) {
        this.buttonList.add(pNode);
        this.buttonCanvas.addScreenChild(pNode);
    }

    private void updateButtonLayout() {
        double d = 0.0;
        Iterator iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            if (!pNode.getVisible()) continue;
            d = Math.max(d, pNode.getFullBoundsReference().getHeight());
        }
        double d2 = 0.0;
        iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            PNode pNode = (PNode)iterator.next();
            if (!pNode.getVisible()) continue;
            pNode.setOffset(d2, (d - pNode.getFullBoundsReference().getHeight()) / 2.0);
            d2 += pNode.getFullBoundsReference().getWidth() + 5.0;
        }
        this.buttonCanvas.setPreferredSize(new Dimension((int)d2, (int)d));
        this.backgroundNode.setSize(this.getWidth(), this.getHeight());
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
        this.updateButtons();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtons();
    }

    public void setTimeDisplay(double d) {
        if (d != this.time) {
            this.time = d;
            this.updateTimeDisplay();
        }
    }

    private void updateTimeDisplay() {
        if (this.timeTextField.isVisible()) {
            String string = this.timeFormat.format(this.time);
            this.timeTextField.setText(string);
        }
    }

    private void updateButtons() {
        this.playPauseButton.setPlaying(!this.paused);
        this.playPauseButton.setEnabled(this.isEnabled());
        this.playPauseTooltipHandler.setText(this.paused ? PLAY_TOOLTIP : PAUSE_TOOLTIP);
        this.stepButton.setEnabled(this.isEnabled() && this.paused);
        this.rewindButton.setEnabled(this.isEnabled());
    }

    public void addTimeControlListener(TimeControlListener timeControlListener) {
        this.listeners.add(timeControlListener);
    }

    private void notifyStepPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).stepPressed();
        }
    }

    private void notifyPlayPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).playPressed();
        }
    }

    private void notifyPausePressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).pausePressed();
        }
    }

    private void notifyRewindPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).restartPressed();
        }
    }

    public static class BackgroundNode
    extends PNode {
        private final PhetPPath backgroundNode = new PhetPPath(new JLabel().getBackground());
        private final PhetPPath tabNode = new PhetPPath();
        private int width;
        private int height;

        public BackgroundNode() {
            this.addChild(this.backgroundNode);
            this.addChild(this.tabNode);
        }

        public void fullPaint(PPaintContext pPaintContext) {
            super.fullPaint(pPaintContext);
        }

        public void setSize(int n, int n2) {
            this.width = n;
            this.height = n2 - 2;
            this.tabNode.setPathTo(this.createPath());
            this.tabNode.setPaint(this.getGradientPaint(n2));
            this.backgroundNode.setPathToRectangle(0.0f, 0.0f, n, n2);
            this.tabNode.setStrokePaint(this.getGradientPaintBorder(n2));
        }

        private Shape createPath() {
            double d = 0.0;
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0);
            doubleGeneralPath.lineToRelative(this.width, 0.0);
            doubleGeneralPath.lineToRelative(-d, this.height);
            doubleGeneralPath.lineTo(d, this.height);
            doubleGeneralPath.lineTo(0.0, 0.0);
            return doubleGeneralPath.getGeneralPath();
        }

        private GradientPaint getGradientPaintBorder(int n) {
            return new GradientPaint(0.0f, n / 4, this.darker(new JLabel().getBackground()), 0.0f, n, this.darker(this.darker(new JLabel().getBackground())));
        }

        private GradientPaint getGradientPaint(int n) {
            return new GradientPaint(0.0f, n / 4, new JLabel().getBackground(), 0.0f, n, this.darker(new JLabel().getBackground()));
        }

        private Color darker(Color color) {
            int n = 30;
            int n2 = 40;
            int n3 = 40;
            return new Color(Math.max(color.getRed() - n, 0), Math.max(color.getGreen() - n2, 0), Math.max(color.getBlue() - n3, 0));
        }
    }
}

