/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;

public class RulerNode
extends PhetPNode {
    private static final Color BACKGROUND_COLOR = new Color(236, 225, 113);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Stroke BACKGROUND_STROKE = new BasicStroke();
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Stroke TICK_STROKE = new BasicStroke();
    private static final String DEFAULT_FONT_NAME = PhetFont.getDefaultFontName();
    private double insetWidth;
    private String[] majorTickLabels;
    private Font majorTickFont;
    private String units;
    private Font unitsFont;
    private String unitsMajorTickLabel;
    private int numMinorTicksBetweenMajors;
    private double majorTickHeight;
    private double minorTickHeight;
    private Stroke tickStroke = TICK_STROKE;
    private double unitsSpacing = 3.0;
    private double fontScale = 1.0;
    private PNode parentNode;
    private PPath backgroundNode;

    public RulerNode(double d, double d2, double d3, String[] stringArray, Font font, String string, Font font2, int n, double d4, double d5) {
        this.setChildrenPickable(false);
        this.insetWidth = d2;
        this.majorTickLabels = stringArray;
        this.majorTickFont = font;
        this.units = string;
        this.unitsFont = font2;
        this.numMinorTicksBetweenMajors = n;
        this.majorTickHeight = d4;
        this.minorTickHeight = d5;
        this.parentNode = new PNode();
        this.addChild(this.parentNode);
        this.backgroundNode = new PPath();
        this.backgroundNode.setPaint(BACKGROUND_COLOR);
        this.backgroundNode.setStrokePaint(BACKGROUND_STROKE_COLOR);
        this.backgroundNode.setStroke(BACKGROUND_STROKE);
        this.parentNode.addChild(this.backgroundNode);
        double d6 = d + 2.0 * d2;
        this.setBounds(0.0, 0.0, d6, d3);
        this.update();
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundNode.setPaint(paint);
    }

    public void setBackgroundStroke(Stroke stroke) {
        this.backgroundNode.setStroke(stroke);
    }

    public void setTickStroke(Stroke stroke) {
        this.tickStroke = stroke;
        this.update();
    }

    public void setUnitsSpacing(double d) {
        this.unitsSpacing = d;
        this.update();
    }

    public void setFontScale(double d) {
        this.fontScale = d;
        this.update();
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        super.internalUpdateBounds(d, d2, d3, d4);
        this.doUpdate(d, d2, d3, d4);
    }

    protected void update() {
        this.doUpdate(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private void doUpdate(double d, double d2, double d3, double d4) {
        this.parentNode.removeAllChildren();
        this.backgroundNode.setPathToRectangle((float)d, (float)d2, (float)d3, (float)d4);
        this.parentNode.addChild(this.backgroundNode);
        if (this.majorTickLabels != null && this.majorTickLabels.length > 0) {
            double d5 = d3 - 2.0 * this.insetWidth;
            double d6 = d5 / (double)(this.majorTickLabels.length - 1);
            double d7 = d6 / (double)(this.numMinorTicksBetweenMajors + 1);
            for (int i = 0; i < this.majorTickLabels.length; ++i) {
                String string = this.majorTickLabels[i];
                PText pText = new PText(string);
                pText.setFont(this.majorTickFont);
                pText.setScale(this.fontScale);
                double d8 = d6 * (double)i + this.insetWidth;
                double d9 = d4 / 2.0 - pText.getFullBounds().getHeight() / 2.0;
                pText.setOffset(d8 - pText.getFullBounds().getWidth() / 2.0, d9);
                this.parentNode.addChild(pText);
                DoubleGeneralPath doubleGeneralPath = RulerNode.createTickMark(d8, d4, this.majorTickHeight);
                PPath pPath = new PPath(doubleGeneralPath.getGeneralPath(), this.tickStroke);
                pPath.setStrokePaint(TICK_COLOR);
                this.parentNode.addChild(pPath);
                if (i < this.majorTickLabels.length - 1) {
                    for (int j = 1; j <= this.numMinorTicksBetweenMajors; ++j) {
                        DoubleGeneralPath doubleGeneralPath2 = RulerNode.createTickMark(d8 + (double)j * d7, d4, this.minorTickHeight);
                        PPath pPath2 = new PPath(doubleGeneralPath2.getGeneralPath(), this.tickStroke);
                        pPath2.setStrokePaint(TICK_COLOR);
                        this.parentNode.addChild(pPath2);
                    }
                }
                if (this.units == null) continue;
                PText pText2 = null;
                if (this.unitsMajorTickLabel != null) {
                    if (this.unitsMajorTickLabel.equals(string)) {
                        pText2 = new PText(this.units);
                    }
                } else if (i == 0) {
                    pText2 = new PText(this.units);
                }
                if (pText2 == null) continue;
                pText2.setFont(this.unitsFont);
                pText2.setScale(this.fontScale);
                this.parentNode.addChild(pText2);
                double d10 = pText.getOffset().getX() + pText.getFullBounds().getWidth() + this.unitsSpacing;
                double d11 = pText.getOffset().getY() + (pText.getFullBounds().getHeight() - pText2.getFullBounds().getHeight());
                pText2.setOffset(d10, d11);
            }
        }
    }

    private static DoubleGeneralPath createTickMark(double d, double d2, double d3) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(d, 0.0);
        doubleGeneralPath.lineTo(d, d3);
        doubleGeneralPath.moveTo(d, d2 - d3);
        doubleGeneralPath.lineTo(d, d2);
        return doubleGeneralPath;
    }
}

