/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class HandleNode
extends PhetPNode {
    private static final Paint DEFAULT_STROKE_PAINT = Color.BLACK;
    private static final Stroke DEFAULT_STROKE = new BasicStroke();
    private PPath handleNode;

    public HandleNode(double d, double d2, Paint paint) {
        this(d, d2, 0.4 * Math.min(d, d2), 0.4 * Math.min(d, d2), paint, DEFAULT_STROKE_PAINT, DEFAULT_STROKE);
    }

    public HandleNode(double d, double d2, double d3, double d4, Paint paint, Paint paint2, Stroke stroke) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (d3 >= Math.min(d, d2)) {
            throw new IllegalArgumentException("thickness is too large: " + d3);
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("cornerWidth must be >= 0");
        }
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, 2.0 * d, d2, d4, d4);
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(d3, d3, 2.0 * (d - d3), d2 - 2.0 * d3, d4, d4);
        Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, d, d2);
        Area area = new Area(double_);
        area.exclusiveOr(new Area(double_2));
        area.intersect(new Area(double_3));
        this.handleNode = new PPath(area);
        this.handleNode.setPaint(paint);
        this.handleNode.setStrokePaint(paint2);
        this.handleNode.setStroke(stroke);
        this.addChild(this.handleNode);
    }

    public void setStroke(Stroke stroke) {
        this.handleNode.setStroke(stroke);
    }
}

