/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GlassPaneCanvas
extends PCanvas {
    private JFrame _parentFrame;
    private Timer _timer;
    private MouseListener _componentCursorListener;
    private MouseMotionListener _canvasCursorListener;
    private ArrayList _componentList;
    private ArrayList _canvasList;

    public GlassPaneCanvas(JFrame jFrame) {
        this._parentFrame = jFrame;
        this.setBackground(new Color(0, 0, 0, 0));
        this.setPanEventHandler(null);
        this.setZoomEventHandler(null);
        this.getLayer().setPickable(false);
        this.getLayer().setChildrenPickable(false);
        this._componentCursorListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                GlassPaneCanvas.this.setCursor(mouseEvent.getComponent().getCursor());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                GlassPaneCanvas.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this._canvasCursorListener = new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                GlassPaneCanvas.this.setCursor(mouseEvent.getComponent().getCursor());
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                GlassPaneCanvas.this.setCursor(mouseEvent.getComponent().getCursor());
            }
        };
        this._timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlassPaneCanvas.this.addCursorListeners(GlassPaneCanvas.this._parentFrame.getLayeredPane());
            }
        });
        this._timer.setInitialDelay(0);
        this._componentList = new ArrayList();
        this._canvasList = new ArrayList();
        this.setOpaque(false);
    }

    protected JFrame getParentFrame() {
        return this._parentFrame;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this._timer.start();
        } else {
            this._timer.stop();
            this.removeCursorListeners();
        }
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
    }

    public synchronized void addInputEventListener(PInputEventListener pInputEventListener) {
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
    }

    private void addCursorListeners(JComponent jComponent) {
        if (jComponent != null) {
            if (!this._componentList.contains(this._componentCursorListener)) {
                jComponent.addMouseListener(this._componentCursorListener);
                this._componentList.add(jComponent);
            }
            if (jComponent instanceof PCanvas && !this._canvasList.contains(jComponent)) {
                jComponent.addMouseMotionListener(this._canvasCursorListener);
                this._canvasList.add(jComponent);
            }
            int n = jComponent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                this.addCursorListeners((JComponent)component);
            }
        }
    }

    private void removeCursorListeners() {
        Object object;
        Iterator iterator = this._componentList.iterator();
        while (iterator.hasNext()) {
            object = (Component)iterator.next();
            ((Component)object).removeMouseListener(this._componentCursorListener);
        }
        object = this._canvasList.iterator();
        while (object.hasNext()) {
            Component component = (Component)object.next();
            component.removeMouseMotionListener(this._canvasCursorListener);
        }
        this._componentList.clear();
        this._canvasList.clear();
    }
}

