/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class PhetAudioClip {
    private final URL url;
    private volatile boolean playing;

    public PhetAudioClip(String string) {
        this(Thread.currentThread().getContextClassLoader().getResource(string));
    }

    public PhetAudioClip(URL uRL) {
        this.url = uRL;
    }

    public void play() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    PhetAudioClip.this.blockingPlay();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockingPlay() {
        this.playing = true;
        try {
            SourceDataLine sourceDataLine;
            Object object;
            AudioInputStream audioInputStream;
            try {
                audioInputStream = AudioSystem.getAudioInputStream(this.url.openStream());
                AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(this.url);
                object = audioFileFormat.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, (AudioFormat)object);
                sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                sourceDataLine.open((AudioFormat)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.playing = false;
                return;
            }
            sourceDataLine.start();
            int n = 0;
            object = new byte[4000];
            while (n != -1) {
                try {
                    n = audioInputStream.read((byte[])object, 0, ((Object)object).length);
                }
                catch (IOException iOException) {
                    break;
                }
                if (n < 0) continue;
                sourceDataLine.write((byte[])object, 0, n);
            }
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        finally {
            this.playing = false;
        }
    }
}

