/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.menu;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.updates.ManualUpdatesManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HelpMenu
extends JMenu
implements ModuleObserver {
    private final JMenuItem onscreenHelp;

    public HelpMenu(final PhetApplication phetApplication) {
        super(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.Title"));
        this.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.TitleMnemonic").charAt(0));
        phetApplication.addModuleObserver(this);
        this.onscreenHelp = new JCheckBoxMenuItem(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.Help"));
        this.onscreenHelp.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.HelpMnemonic").charAt(0));
        this.onscreenHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetApplication.getActiveModule().setHelpEnabled(HelpMenu.this.onscreenHelp.isSelected());
            }
        });
        this.onscreenHelp.setEnabled(phetApplication.getActiveModule() != null && phetApplication.getActiveModule().hasHelp());
        this.add(this.onscreenHelp);
        final JMenuItem jMenuItem = new JMenuItem(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.MegaHelp"));
        jMenuItem.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.MegaHelpMnemonic").charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (phetApplication.getActiveModule().hasMegaHelp()) {
                    phetApplication.getActiveModule().showMegaHelp();
                } else {
                    JOptionPane.showMessageDialog(PhetApplication.getInstance().getPhetFrame(), "No MegaHelp available for this module.");
                }
            }
        });
        phetApplication.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
                jMenuItem.setVisible(moduleEvent.getModule().hasMegaHelp());
            }

            public void moduleRemoved(ModuleEvent moduleEvent) {
            }
        });
        jMenuItem.setVisible(phetApplication.getActiveModule() != null && phetApplication.getActiveModule().hasMegaHelp());
        this.add(jMenuItem);
        this.addSeparator();
        if (phetApplication.getSimInfo().isUpdatesFeatureIncluded()) {
            this.add(new CheckForSimUpdateMenuItem());
        }
        JMenuItem jMenuItem2 = new JMenuItem(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.About"));
        jMenuItem2.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.AboutMnemonic").charAt(0));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetApplication.showAboutDialog();
            }
        });
        this.add(jMenuItem2);
    }

    public void setHelpSelected(boolean bl) {
        this.onscreenHelp.setSelected(bl);
    }

    public void moduleAdded(ModuleEvent moduleEvent) {
    }

    public void activeModuleChanged(ModuleEvent moduleEvent) {
        Module module = moduleEvent.getModule();
        if (module != null) {
            this.onscreenHelp.setEnabled(module.hasHelp());
            this.onscreenHelp.setSelected(module.isHelpEnabled());
        }
    }

    public void moduleRemoved(ModuleEvent moduleEvent) {
    }

    private class CheckForSimUpdateMenuItem
    extends JMenuItem {
        private CheckForSimUpdateMenuItem() {
            super(PhetCommonResources.getInstance().getLocalizedString("Common.updates.checkForSimUpdate"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ManualUpdatesManager.getInstance().checkForSimUpdates();
                }
            });
        }
    }
}

