/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;

public class DownloadThread
extends Thread {
    private final ArrayList requests = new ArrayList();
    private final ArrayList listeners = new ArrayList();
    private int totalContentLength = 0;
    private int downloadedContentLength = 0;
    private boolean canceled = false;
    private boolean succeeded = false;

    public void run() {
        try {
            this.download();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addRequest(String string, String string2, File file) throws IOException {
        if (this.isAlive()) {
            throw new IllegalStateException("cannot add downloads while thread is alive");
        }
        URLConnection uRLConnection = new URL(string2).openConnection();
        int n = uRLConnection.getContentLength();
        this.totalContentLength += n;
        DownloadRequest downloadRequest = new DownloadRequest(string, string2, file, n);
        this.requests.add(downloadRequest);
        this.notifyRequestAdded(downloadRequest);
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean getSucceeded() {
        return this.succeeded;
    }

    private void download() throws IOException {
        this.downloadedContentLength = 0;
        this.canceled = false;
        ArrayList arrayList = new ArrayList(this.requests);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && !this.canceled) {
            try {
                this.download((DownloadRequest)iterator.next());
            }
            catch (IOException iOException) {
                this.notifyFailed();
                throw iOException;
            }
        }
        if (this.canceled) {
            this.notifyCanceled();
        } else {
            this.succeeded = true;
            this.notifySucceeded();
        }
    }

    private void download(DownloadRequest downloadRequest) throws IOException {
        try {
            downloadRequest.destinationFile.getParentFile().mkdirs();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(downloadRequest.destinationFile));
            URLConnection uRLConnection = new URL(downloadRequest.sourceURL).openConnection();
            int n = uRLConnection.getContentLength();
            this.totalContentLength += n - downloadRequest.expectedContentLength;
            int n2 = 0;
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[2048];
            int n3 = 0;
            boolean bl = false;
            while (!bl && !this.canceled) {
                n3 = inputStream.read(byArray);
                if (n3 != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n3);
                    this.downloadedContentLength += n3;
                    double d = (double)(n2 += n3) / (double)n;
                    double d2 = (double)this.downloadedContentLength / (double)this.totalContentLength;
                    this.notifyProgress(downloadRequest, d, d2);
                    DownloadThread.yield();
                    continue;
                }
                bl = true;
            }
            inputStream.close();
            ((OutputStream)bufferedOutputStream).close();
            if (!this.canceled) {
                this.notifyCompleted(downloadRequest);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.notifyError(downloadRequest, iOException.getMessage(), iOException);
            throw iOException;
        }
    }

    public void addListener(DownloadThreadListener downloadThreadListener) {
        this.listeners.add(downloadThreadListener);
    }

    public void removeListener(DownloadThreadListener downloadThreadListener) {
        this.listeners.remove(downloadThreadListener);
    }

    private void notifySucceeded() {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).succeeded();
        }
    }

    private void notifyFailed() {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).failed();
        }
    }

    private void notifyCanceled() {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).canceled();
        }
    }

    private void notifyRequestAdded(DownloadRequest downloadRequest) {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).requestAdded(downloadRequest.requestName, downloadRequest.sourceURL, downloadRequest.destinationFile);
        }
    }

    private void notifyProgress(DownloadRequest downloadRequest, double d, double d2) {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).progress(downloadRequest.requestName, downloadRequest.sourceURL, downloadRequest.destinationFile, d, d2);
        }
    }

    private void notifyCompleted(DownloadRequest downloadRequest) {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).completed(downloadRequest.requestName, downloadRequest.sourceURL, downloadRequest.destinationFile);
        }
    }

    private void notifyError(DownloadRequest downloadRequest, String string, Exception exception) {
        ArrayList arrayList = this.getListeners();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((DownloadThreadListener)iterator.next()).error(downloadRequest.requestName, downloadRequest.sourceURL, downloadRequest.destinationFile, string, exception);
        }
    }

    private ArrayList getListeners() {
        return new ArrayList(this.listeners);
    }

    public static interface DownloadThreadListener {
        public void succeeded();

        public void failed();

        public void canceled();

        public void requestAdded(String var1, String var2, File var3);

        public void progress(String var1, String var2, File var3, double var4, double var6);

        public void completed(String var1, String var2, File var3);

        public void error(String var1, String var2, File var3, String var4, Exception var5);
    }

    private static class DownloadRequest {
        private final String requestName;
        private final String sourceURL;
        private final File destinationFile;
        private final int expectedContentLength;

        public DownloadRequest(String string, String string2, File file, int n) {
            this.requestName = string;
            this.sourceURL = string2;
            this.destinationFile = file;
            this.expectedContentLength = n;
        }
    }
}

