/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.updates.dialogs;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.updates.IAskMeLaterStrategy;
import edu.colorado.phet.common.phetcommon.updates.IVersionSkipper;
import edu.colorado.phet.common.phetcommon.updates.SimUpdater;
import edu.colorado.phet.common.phetcommon.util.DeploymentScenario;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class SimAbstractUpdateDialog
extends PaintImmediateDialog {
    private static final String TITLE = PhetCommonResources.getString("Common.updates.updateAvailable");
    private static final String ASK_ME_LATER_BUTTON = PhetCommonResources.getString("Common.updates.askMeLater");
    private static final String SKIP_UPDATE_BUTTON = PhetCommonResources.getString("Common.updates.skipThisUpdate");
    private static final String CANCEL_BUTTON = PhetCommonResources.getString("Common.choice.cancel");
    private static final String TRY_IT_LINK = PhetCommonResources.getString("Common.updates.tryIt");
    private final ISimInfo simInfo;
    private final PhetVersion newVersion;

    protected SimAbstractUpdateDialog(Frame frame, ISimInfo iSimInfo, PhetVersion phetVersion) {
        super(frame, TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.simInfo = iSimInfo;
        this.newVersion = phetVersion;
    }

    protected void initGUI() {
        JPanel jPanel = this.createMessagePanel(this.simInfo, this.newVersion);
        JPanel jPanel2 = this.createButtonPanel(this.simInfo, this.newVersion);
        JPanel jPanel3 = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jPanel, n++, n2);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n++, n2, 2);
        easyGridBagLayout.addAnchoredComponent(jPanel2, n++, n2, 10);
        this.setContentPane(jPanel3);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createMessagePanel(ISimInfo iSimInfo, PhetVersion phetVersion) {
        final String string = iSimInfo.getProjectName();
        final String string2 = iSimInfo.getFlavor();
        String string3 = iSimInfo.getName();
        PhetVersion phetVersion2 = iSimInfo.getVersion();
        JLabel jLabel = new JLabel(SimAbstractUpdateDialog.getVersionComparisonHTML(string3, phetVersion2.formatForTitleBar(), phetVersion.formatForTitleBar()));
        String string4 = "<html><u>" + TRY_IT_LINK + "</u></html>";
        JLabel jLabel2 = new JLabel(string4);
        jLabel2.setCursor(Cursor.getPredefinedCursor(12));
        jLabel2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PhetServiceManager.showSimPage(string, string2);
            }
        });
        jLabel2.setForeground(Color.blue);
        JComponent jComponent = this.createAdditionalMessageComponent();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jLabel, n++, n2);
        easyGridBagLayout.addComponent(Box.createVerticalStrut(5), n++, n2);
        easyGridBagLayout.addComponent(jLabel2, n++, n2);
        if (jComponent != null) {
            easyGridBagLayout.addComponent(Box.createVerticalStrut(5), n++, n2);
            easyGridBagLayout.addComponent(jComponent, n++, n2);
        }
        return jPanel;
    }

    protected JComponent createAdditionalMessageComponent() {
        return null;
    }

    protected abstract JPanel createButtonPanel(ISimInfo var1, PhetVersion var2);

    private static String getVersionComparisonHTML(String string, String string2, String string3) {
        String string4 = PhetCommonResources.getString("Common.updates.versionComparison");
        Object[] objectArray = new Object[]{string, string2, string3};
        return MessageFormat.format(string4, objectArray);
    }

    protected static class CancelButton
    extends JButton {
        public CancelButton(final JDialog jDialog) {
            super(CANCEL_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
        }
    }

    protected static class SkipVersionButton
    extends JButton {
        public SkipVersionButton(final JDialog jDialog, final IVersionSkipper iVersionSkipper, final PhetVersion phetVersion) {
            super(SKIP_UPDATE_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    iVersionSkipper.setSkippedVersion(phetVersion.getRevisionAsInt());
                    jDialog.dispose();
                }
            });
        }
    }

    protected static class AskMeLaterButton
    extends JButton {
        public AskMeLaterButton(final JDialog jDialog, final IAskMeLaterStrategy iAskMeLaterStrategy) {
            super(ASK_ME_LATER_BUTTON);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    iAskMeLaterStrategy.setStartTime(System.currentTimeMillis());
                    jDialog.dispose();
                }
            });
        }
    }

    protected static class UpdateButton
    extends JButton {
        public UpdateButton(final JDialog jDialog, final ISimInfo iSimInfo, final PhetVersion phetVersion) {
            super(PhetCommonResources.getString("Common.updates.updateNow"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                    if (DeploymentScenario.getInstance().isOnline()) {
                        PhetServiceManager.showSimPage(iSimInfo.getProjectName(), iSimInfo.getFlavor());
                    } else {
                        new SimUpdater().updateSim(iSimInfo, phetVersion);
                    }
                }
            });
        }
    }
}

