/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.dialogs.ErrorDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class JARLauncher
implements IProguardKeepClass {
    public static final String PROPERTIES_FILE_NAME = "jar-launcher.properties";
    public static final String FLAVOR_KEY = "flavor";
    public static final String LANGUAGE_KEY = "language";
    public static final String COUNTRY_KEY = "country";
    private static final String INSTRUCTIONS = "<html>This program contains {0} simulations.<br>Select the simulation that you wish to start:<br></html>";
    private static final String START_BUTTON = "Start";
    private static final String CANCEL_BUTTON = "Cancel";
    private static final String ERROR_FAILED_TO_LAUNCH = "Failed to launch JAR.";
    private static final String ERROR_NO_SIMS = "No simulations found in this JAR.";
    private static final String ERROR_SIM_NOT_FOUND = "Simulation {0} not found in this JAR.";
    static /* synthetic */ Class array$Ljava$lang$String;

    public static String getPropertiesFileName() {
        return PROPERTIES_FILE_NAME;
    }

    /*
     * Enabled aggressive block sorting
     */
    public JARLauncher(String[] stringArray) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Properties properties = JARLauncher.readProperties(PROPERTIES_FILE_NAME);
        SimulationInfo[] simulationInfoArray = JARLauncher.getSimulations(properties, stringArray);
        if (simulationInfoArray.length == 0) {
            throw new RuntimeException(ERROR_NO_SIMS);
        }
        JARLauncher.setLocaleForOfflineJARs(properties);
        String string = properties.getProperty(FLAVOR_KEY);
        if (string != null) {
            SimulationInfo simulationInfo = JARLauncher.getFlavor(simulationInfoArray, string);
            if (simulationInfo != null) {
                simulationInfo.launch();
                return;
            }
            Object[] objectArray = new Object[]{string};
            throw new RuntimeException(MessageFormat.format(ERROR_SIM_NOT_FOUND, objectArray));
        }
        if (simulationInfoArray.length == 1) {
            simulationInfoArray[0].launch();
            return;
        }
        JARLauncherGUI jARLauncherGUI = new JARLauncherGUI(simulationInfoArray);
        SwingUtils.centerWindowOnScreen(jARLauncherGUI);
        jARLauncherGUI.setVisible(true);
    }

    private static Properties readProperties(String string) throws IOException {
        Properties properties = new Properties();
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL != null) {
            properties.load(uRL.openStream());
        } else {
            File file = new File(string);
            properties.load(new FileInputStream(file));
        }
        return properties;
    }

    private static SimulationInfo getFlavor(SimulationInfo[] simulationInfoArray, String string) {
        SimulationInfo simulationInfo = null;
        for (int i = 0; i < simulationInfoArray.length; ++i) {
            if (!simulationInfoArray[i].getFlavor().equals(string)) continue;
            simulationInfo = simulationInfoArray[i];
        }
        return simulationInfo;
    }

    private static SimulationInfo[] getSimulations(Properties properties, String[] stringArray) {
        String[] stringArray2 = JARLauncher.listFlavors(properties);
        ArrayList<SimulationInfo> arrayList = new ArrayList<SimulationInfo>();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            SimulationInfo simulationInfo = JARLauncher.getSimulation(properties, string, stringArray);
            arrayList.add(simulationInfo);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                SimulationInfo simulationInfo = (SimulationInfo)object;
                SimulationInfo simulationInfo2 = (SimulationInfo)object2;
                return simulationInfo.getTitle().compareToIgnoreCase(simulationInfo2.getTitle());
            }
        });
        return arrayList.toArray(new SimulationInfo[arrayList.size()]);
    }

    private static String[] listFlavors(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String string;
            int n;
            String string2 = (String)enumeration.nextElement();
            if (!string2.toLowerCase().startsWith("project.flavor") || (n = (string = string2.substring("project.flavor.".length())).indexOf(46)) < 0) continue;
            String string3 = string.substring(0, n);
            hashSet.add(string3);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private static SimulationInfo getSimulation(Properties properties, String string, String[] stringArray) {
        String string2 = properties.getProperty("project.flavor." + string + ".mainclass");
        String string3 = JARLauncher.getTitle(properties, string);
        String string4 = properties.getProperty("project.flavor." + string + ".args");
        String[] stringArray2 = JARLauncher.combineArgs(string4, stringArray);
        return new SimulationInfo(string, string3, string2, stringArray2);
    }

    private static String getTitle(Properties properties, String string) {
        if (new StringTokenizer(string, "_").countTokens() == 2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            PhetResources phetResources = new PhetResources(string2);
            return phetResources.getLocalizedString(string3 + ".name");
        }
        return properties.getProperty("project.flavor." + string + ".title");
    }

    private static String[] combineArgs(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void setLocaleForOfflineJARs(Properties properties) {
        String string = properties.getProperty(LANGUAGE_KEY);
        if (string != null && !(string = string.trim()).equals("")) {
            System.out.println("JARLauncher: setting javaws.user.language=" + string);
            System.setProperty("javaws.user.language", string);
            String string2 = properties.getProperty(COUNTRY_KEY);
            if (string2 != null && !(string2 = string2.trim()).equals("")) {
                System.out.println("JARLauncher: setting javaws.user.country=" + string2);
                System.setProperty("javaws.user.country", string2);
            }
        }
    }

    private static void showException(Frame frame, Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(frame, ERROR_FAILED_TO_LAUNCH, exception);
        SwingUtils.centerWindowOnScreen(errorDialog);
        ((Dialog)errorDialog).setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            new JARLauncher(stringArray);
        }
        catch (Exception exception) {
            JARLauncher.showException(null, exception);
        }
    }

    private static class JARLauncherGUI
    extends JFrame {
        private SimulationInfo selectedSim;

        public JARLauncherGUI(SimulationInfo[] simulationInfoArray) {
            this.createUI(simulationInfoArray);
            this.setResizable(false);
            this.setDefaultCloseOperation(3);
        }

        private void createUI(SimulationInfo[] simulationInfoArray) {
            JComponent jComponent = this.createInputPanel(simulationInfoArray);
            JPanel jPanel = this.createActionsPanel();
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)new JSeparator(), "North");
            jPanel2.add((Component)jPanel, "Center");
            BorderLayout borderLayout = new BorderLayout(20, 20);
            JPanel jPanel3 = new JPanel(borderLayout);
            jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel3.add((Component)jComponent, "Center");
            jPanel3.add((Component)jPanel2, "South");
            this.getContentPane().add(jPanel3);
            this.pack();
            if ((double)this.getHeight() > (double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.75) {
                this.setSize(this.getWidth(), (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.75));
            }
        }

        private JComponent createInputPanel(final SimulationInfo[] simulationInfoArray) {
            Object[] objectArray = new Object[]{new Integer(simulationInfoArray.length)};
            JLabel jLabel = new JLabel(MessageFormat.format(JARLauncher.INSTRUCTIONS, objectArray));
            JPanel jPanel = new JPanel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            jPanel.setLayout(easyGridBagLayout);
            int n = 0;
            int n2 = 0;
            easyGridBagLayout.addComponent(jLabel, n++, n2);
            ButtonGroup buttonGroup = new ButtonGroup();
            int n3 = 0;
            while (n3 < simulationInfoArray.length) {
                String string = simulationInfoArray[n3].getTitle();
                if (string == null || string.trim().length() == 0) {
                    string = simulationInfoArray[n3].getMainClass().substring(simulationInfoArray[n3].getMainClass().lastIndexOf(46) + 1);
                }
                JRadioButton jRadioButton = new JRadioButton(string, n3 == 0);
                final int n4 = n3++;
                jRadioButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JARLauncherGUI.this.selectedSim = simulationInfoArray[n4];
                    }
                });
                buttonGroup.add(jRadioButton);
                easyGridBagLayout.addComponent(jRadioButton, n++, n2);
            }
            this.selectedSim = simulationInfoArray[0];
            if (simulationInfoArray.length > 10) {
                return new JScrollPane(jPanel);
            }
            return jPanel;
        }

        protected JPanel createActionsPanel() {
            JButton jButton = new JButton(JARLauncher.START_BUTTON);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JARLauncherGUI.this.handleStart();
                }
            });
            JButton jButton2 = new JButton(JARLauncher.CANCEL_BUTTON);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JARLauncherGUI.this.handleCancel();
                }
            });
            JPanel jPanel = new JPanel(new GridLayout(1, 1, 5, 0));
            jPanel.add(jButton);
            jPanel.add(jButton2);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(jPanel);
            return jPanel2;
        }

        private void handleCancel() {
            this.dispose();
            System.exit(0);
        }

        private void handleStart() {
            try {
                this.selectedSim.launch();
                this.dispose();
            }
            catch (Exception exception) {
                JARLauncher.showException(this, exception);
            }
        }
    }

    private static class SimulationInfo {
        private final String flavor;
        private final String title;
        private final String mainClass;
        private final String[] args;

        public SimulationInfo(String string, String string2, String string3, String[] stringArray) {
            this.flavor = string;
            this.title = string2;
            this.mainClass = string3;
            this.args = stringArray;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public void launch() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Class<?> clazz = Class.forName(this.getMainClass());
            final Method method = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JARLauncher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        method.invoke(null, new Object[]{SimulationInfo.this.args});
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            });
            thread.start();
        }

        public String getFlavor() {
            return this.flavor;
        }
    }
}

