/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.IMotionBody;
import edu.colorado.phet.common.motion.model.TimeData;
import java.util.ArrayList;

public interface UpdateStrategy {
    public void update(IMotionBody var1, double var2, double var4);

    public static class AccelerationDriven
    extends DefaultUpdateStrategy {
        public TimeData getNewX(IMotionBody iMotionBody, double d, double d2) {
            return new TimeData(iMotionBody.getPosition() + (iMotionBody.getVelocity() + this.getNewV(iMotionBody, d, d2).getValue()) / 2.0 * d, d2);
        }

        public TimeData getNewV(IMotionBody iMotionBody, double d, double d2) {
            return new TimeData(iMotionBody.getVelocity() + iMotionBody.getAcceleration() * d, d2);
        }

        public TimeData getNewA(IMotionBody iMotionBody, double d, double d2) {
            return new TimeData(iMotionBody.getAcceleration(), d2);
        }
    }

    public static class VelocityDriven
    extends DefaultUpdateStrategy {
        int velWindow = 10;

        public TimeData getNewV(IMotionBody iMotionBody, double d, double d2) {
            return new TimeData(iMotionBody.getVelocity(), d2);
        }

        public TimeData getNewA(IMotionBody iMotionBody, double d, double d2) {
            TimeData timeData = MotionMath.getDerivative(iMotionBody.getRecentVelocityTimeSeries(Math.min(this.velWindow, iMotionBody.getAccelerationSampleCount())));
            timeData = new TimeData(timeData.getValue(), timeData.getTime() + d);
            return timeData;
        }

        public TimeData getNewX(IMotionBody iMotionBody, double d, double d2) {
            return new TimeData(iMotionBody.getPosition() + iMotionBody.getVelocity() * d, d2);
        }
    }

    public static class PositionDriven
    extends DefaultUpdateStrategy {
        private int velocityWindow = 6;
        private int accelerationWindow = 6;

        public TimeData getNewX(IMotionBody iMotionBody, double d, double d2) {
            return new TimeData(iMotionBody.getPosition(), d2);
        }

        public TimeData getNewV(IMotionBody iMotionBody, double d, double d2) {
            return MotionMath.getDerivative(MotionMath.smooth(iMotionBody.getRecentPositionTimeSeries(Math.min(this.velocityWindow, iMotionBody.getPositionSampleCount())), 1));
        }

        public TimeData getNewA(IMotionBody iMotionBody, double d, double d2) {
            return MotionMath.getDerivative(MotionMath.smooth(iMotionBody.getRecentVelocityTimeSeries(Math.min(this.accelerationWindow, iMotionBody.getVelocitySampleCount())), 1));
        }
    }

    public static abstract class DefaultUpdateStrategy
    implements UpdateStrategy {
        private double min;
        private double max;
        private ArrayList listeners = new ArrayList();

        protected DefaultUpdateStrategy() {
            this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public DefaultUpdateStrategy(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        public abstract TimeData getNewX(IMotionBody var1, double var2, double var4);

        public abstract TimeData getNewV(IMotionBody var1, double var2, double var4);

        public abstract TimeData getNewA(IMotionBody var1, double var2, double var4);

        public void doDefaultUpdate(IMotionBody iMotionBody, double d, double d2) {
            double d3 = iMotionBody.getPosition();
            double d4 = iMotionBody.getVelocity();
            double d5 = iMotionBody.getAcceleration();
            TimeData timeData = this.getNewX(iMotionBody, d, d2);
            TimeData timeData2 = this.getNewV(iMotionBody, d, d2);
            TimeData timeData3 = this.getNewA(iMotionBody, d, d2);
            if (timeData.getValue() > this.max) {
                timeData = new TimeData(this.max, timeData.getTime());
                timeData2 = new TimeData(0.0, timeData2.getTime());
                timeData3 = new TimeData(0.0, timeData3.getTime());
                if (d3 < this.max) {
                    this.notifyCrashedMax(d4);
                }
            } else if (timeData.getValue() < this.min) {
                timeData = new TimeData(this.min, timeData.getTime());
                timeData2 = new TimeData(0.0, timeData2.getTime());
                timeData3 = new TimeData(0.0, timeData3.getTime());
                if (d3 > this.min) {
                    this.notifyCrashedMin(d4);
                }
            }
            iMotionBody.addPositionData(timeData);
            iMotionBody.addVelocityData(timeData2);
            iMotionBody.addAccelerationData(timeData3);
        }

        private void notifyCrashedMin(double d) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).crashedMin(d);
            }
        }

        private void notifyCrashedMax(double d) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).crashedMax(d);
            }
        }

        public void update(IMotionBody iMotionBody, double d, double d2) {
            this.doDefaultUpdate(iMotionBody, d, d2);
        }

        public static interface Listener {
            public void crashedMin(double var1);

            public void crashedMax(double var1);
        }
    }
}

