/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.MotionTimeSeriesModel;
import edu.colorado.phet.common.motion.model.TimeSeriesFactory;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.timeseries.model.RecordableModel;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.common.timeseries.model.TimeState;
import java.util.ArrayList;

public class MotionModel {
    private TimeSeriesModel timeSeriesModel;
    private ITemporalVariable timeVariable;
    private ArrayList temporalVariables = new ArrayList();
    private ConstantDtClock clock;

    public MotionModel(ConstantDtClock constantDtClock, TimeSeriesFactory timeSeriesFactory) {
        this.timeVariable = new DefaultTemporalVariable(timeSeriesFactory);
        this.clock = constantDtClock;
        RecordableModel recordableModel = new RecordableModel(){

            public void stepInTime(double d) {
                MotionModel.this.stepInTime(d);
            }

            public Object getState() {
                return new Double(MotionModel.this.timeVariable.getValue());
            }

            public void setState(Object object) {
                MotionModel.this.setPlaybackTime((Double)object);
            }

            public void clear() {
                MotionModel.this.clear();
            }
        };
        this.timeSeriesModel = this.createTimeSeriesModel(recordableModel, constantDtClock);
        this.timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void modeChanged() {
                TimeState timeState;
                if (MotionModel.this.timeSeriesModel.isRecordMode() && (timeState = MotionModel.this.timeSeriesModel.getSeries().getLastPoint()) != null) {
                    Object object = timeState.getValue();
                    MotionModel.this.setPlaybackTime((Double)object);
                }
            }
        });
        this.timeSeriesModel.setRecordMode();
        constantDtClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                MotionModel.this.timeSeriesModel.stepMode(clockEvent.getSimulationTimeChange());
            }
        });
        this.addTemporalVariable(this.timeVariable);
    }

    protected TimeSeriesModel createTimeSeriesModel(RecordableModel recordableModel, ConstantDtClock constantDtClock) {
        return new MotionTimeSeriesModel(recordableModel, constantDtClock);
    }

    protected void setPlaybackTime(double d) {
        for (int i = 0; i < this.temporalVariables.size(); ++i) {
            ((ITemporalVariable)this.temporalVariables.get(i)).setPlaybackTime(d);
        }
    }

    public void addTemporalVariable(ITemporalVariable iTemporalVariable) {
        this.temporalVariables.add(iTemporalVariable);
    }

    public void stepInTime(double d) {
        double d2 = this.timeVariable.getValue() + d;
        this.timeVariable.addValue(d2, d2);
    }

    public void clear() {
        this.timeVariable.setValue(0.0);
        for (int i = 0; i < this.temporalVariables.size(); ++i) {
            ((ITemporalVariable)this.temporalVariables.get(i)).clear();
        }
        this.timeSeriesModel.clear();
    }

    protected void defaultUpdate(ITemporalVariable iTemporalVariable) {
        iTemporalVariable.addValue(iTemporalVariable.getValue(), this.getTime());
    }

    public double getTime() {
        return this.timeVariable.getValue();
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.timeSeriesModel;
    }

    public void resetAll() {
        this.clear();
    }
}

