/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.IMotionBody;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.TimeSeriesFactory;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.motion.model.UpdateableObject;

public class MotionBody
implements IMotionBody,
UpdateableObject {
    private ITemporalVariable x;
    private ITemporalVariable v;
    private ITemporalVariable a;
    private UpdateStrategy.PositionDriven positionDriven = new UpdateStrategy.PositionDriven();
    private UpdateStrategy.VelocityDriven velocityDriven = new UpdateStrategy.VelocityDriven();
    private UpdateStrategy.AccelerationDriven accelDriven = new UpdateStrategy.AccelerationDriven();
    private UpdateStrategy updateStrategy = this.positionDriven;

    public MotionBody() {
        this(new DefaultTemporalVariable(), new DefaultTemporalVariable(), new DefaultTemporalVariable());
    }

    public MotionBody(TimeSeriesFactory timeSeriesFactory) {
        this(new DefaultTemporalVariable(timeSeriesFactory), new DefaultTemporalVariable(timeSeriesFactory), new DefaultTemporalVariable(timeSeriesFactory));
    }

    public MotionBody(DefaultTemporalVariable defaultTemporalVariable, DefaultTemporalVariable defaultTemporalVariable2, DefaultTemporalVariable defaultTemporalVariable3) {
        this.x = defaultTemporalVariable;
        this.v = defaultTemporalVariable2;
        this.a = defaultTemporalVariable3;
    }

    public void setTime(double d) {
        this.x.setPlaybackTime(d);
        this.v.setPlaybackTime(d);
        this.a.setPlaybackTime(d);
    }

    public void stepInTime(double d, double d2) {
        this.updateStrategy.update(this, d2, d);
    }

    public void setVelocity(double d) {
        this.v.setValue(d);
    }

    public void setPosition(double d) {
        this.x.setValue(d);
    }

    public void clear() {
        this.x.clear();
        this.v.clear();
        this.a.clear();
    }

    public double getAcceleration() {
        return this.a.getValue();
    }

    public double getVelocity() {
        return this.v.getValue();
    }

    public double getPosition() {
        return this.x.getValue();
    }

    public ITemporalVariable getPositionVariable() {
        return this.x;
    }

    public ITemporalVariable getVelocityVariable() {
        return this.v;
    }

    public ITemporalVariable getAccelerationVariable() {
        return this.a;
    }

    public void reset() {
        this.clear();
        this.getPositionVariable().setValue(0.0);
        this.getVelocityVariable().setValue(0.0);
        this.getAccelerationVariable().setValue(0.0);
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public boolean isAccelDriven() {
        return this.updateStrategy == this.accelDriven;
    }

    public boolean isPositionDriven() {
        return this.updateStrategy == this.positionDriven;
    }

    public void setVelocityDriven() {
        this.setUpdateStrategy(this.velocityDriven);
    }

    public void setPositionDriven() {
        this.setUpdateStrategy(this.positionDriven);
    }

    public UpdateStrategy.PositionDriven getPositionDriven() {
        return this.positionDriven;
    }

    public UpdateStrategy.VelocityDriven getVelocityDriven() {
        return this.velocityDriven;
    }

    public UpdateStrategy.AccelerationDriven getAccelDriven() {
        return this.accelDriven;
    }

    public void addPositionData(double d, double d2) {
        this.x.addValue(d, d2);
    }

    public void addPositionData(TimeData timeData) {
        this.addPositionData(timeData.getValue(), timeData.getTime());
    }

    public void addVelocityData(TimeData timeData) {
        this.addVelocityData(timeData.getValue(), timeData.getTime());
    }

    public void addAccelerationData(TimeData timeData) {
        this.addAccelerationData(timeData.getValue(), timeData.getTime());
    }

    public void addVelocityData(double d, double d2) {
        this.v.addValue(d, d2);
    }

    public void addAccelerationData(double d, double d2) {
        this.a.addValue(d, d2);
    }

    public TimeData[] getRecentAccelerationTimeSeries(int n) {
        return this.a.getRecentSeries(n);
    }

    public TimeData[] getRecentVelocityTimeSeries(int n) {
        return this.v.getRecentSeries(n);
    }

    public TimeData[] getRecentPositionTimeSeries(int n) {
        return this.x.getRecentSeries(n);
    }

    public int getAccelerationSampleCount() {
        return this.a.getSampleCount();
    }

    public int getVelocitySampleCount() {
        return this.v.getSampleCount();
    }

    public int getPositionSampleCount() {
        return this.x.getSampleCount();
    }

    protected UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }
}

