/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.TimeSeriesFactory;

public class HeuristicPrunedTimeSeries
extends DefaultTimeSeries {
    private double maxTime;

    public HeuristicPrunedTimeSeries(double d) {
        this.maxTime = d;
    }

    public void addValue(double d, double d2) {
        super.addValue(d, d2);
        if (d2 >= this.maxTime * 4.0) {
            super.removeValue(this.getSampleCount() / 2);
        }
    }

    public static class Factory
    implements TimeSeriesFactory {
        private double maxTime;

        public Factory(double d) {
            this.maxTime = d;
        }

        public DefaultTimeSeries createTimeSeries() {
            return new HeuristicPrunedTimeSeries(this.maxTime);
        }
    }
}

