/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.DefaultVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.TimeSeriesFactory;

public class DefaultTemporalVariable
implements ITemporalVariable {
    private DefaultVariable variable;
    private DefaultTimeSeries series;

    public DefaultTemporalVariable() {
        this(0.0);
    }

    public DefaultTemporalVariable(double d) {
        this(new DefaultVariable(d), new DefaultTimeSeries());
    }

    public DefaultTemporalVariable(DefaultVariable defaultVariable, DefaultTimeSeries defaultTimeSeries) {
        this.variable = defaultVariable;
        this.series = defaultTimeSeries;
    }

    public DefaultTemporalVariable(TimeSeriesFactory timeSeriesFactory) {
        this(0.0, timeSeriesFactory);
    }

    public DefaultTemporalVariable(double d, TimeSeriesFactory timeSeriesFactory) {
        this(new DefaultVariable(d), timeSeriesFactory.createTimeSeries());
    }

    public String toString() {
        return "value=" + this.variable + ", series=" + this.series;
    }

    public void addValue(double d, double d2) {
        this.variable.setValue(d);
        this.series.addValue(d, d2);
    }

    public void setValue(double d) {
        this.variable.setValue(d);
    }

    public void setPlaybackTime(double d) {
        this.setValue(this.series.getValueForTime(d));
    }

    public double getValue() {
        return this.variable.getValue();
    }

    public void addListener(IVariable.Listener listener) {
        this.variable.addListener(listener);
    }

    public void removeListener(IVariable.Listener listener) {
        this.variable.removeListener(listener);
    }

    public TimeData[] getRecentSeries(int n) {
        return this.series.getRecentSeries(n);
    }

    public TimeData getData(int n) {
        return this.series.getData(n);
    }

    public TimeData getRecentData(int n) {
        return this.series.getRecentData(n);
    }

    public int getSampleCount() {
        return this.series.getSampleCount();
    }

    public void clear() {
        this.series.clear();
    }

    public void addListener(ITemporalVariable.Listener listener) {
        this.series.addListener(listener);
        this.variable.addListener(listener);
    }

    public double estimateAverage(int n) {
        double d = 0.0;
        int n2 = Math.min(n, this.getSampleCount());
        for (int i = 0; i < n2; ++i) {
            d += this.getRecentData(i).getValue();
        }
        return d / (double)n2;
    }
}

