/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSetNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.common.timeseries.ui.TimeSeriesControlPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;

public class TimeSeriesGraphSetNode
extends PNode {
    private GraphSetNode graphSetNode;
    private PSwing timeSeriesControlPanelNode;
    private boolean constructed = false;
    private PhetPPath background;

    public TimeSeriesGraphSetNode(GraphSetModel graphSetModel, TimeSeriesModel timeSeriesModel, double d, double d2) {
        this.setBounds(0.0, 0.0, 800.0, 600.0);
        this.graphSetNode = new GraphSetNode(graphSetModel);
        TimeSeriesControlPanel timeSeriesControlPanel = new TimeSeriesControlPanel(timeSeriesModel, d, d2);
        this.timeSeriesControlPanelNode = new PSwing(timeSeriesControlPanel);
        this.background = new PhetPPath(new JLabel().getBackground());
        this.addChild(this.background);
        this.addChild(this.graphSetNode);
        this.addChild(this.timeSeriesControlPanelNode);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TimeSeriesGraphSetNode.this.relayout();
            }
        };
        this.addPropertyChangeListener("bounds", propertyChangeListener);
        this.addPropertyChangeListener("fullBounds", propertyChangeListener);
        this.addPropertyChangeListener("visible", propertyChangeListener);
        this.constructed = true;
        this.relayout();
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        this.relayout();
    }

    private void relayout() {
        if (this.constructed) {
            PBounds pBounds = this.getBounds();
            this.graphSetNode.setBounds(((RectangularShape)pBounds).getX(), ((RectangularShape)pBounds).getY(), ((RectangularShape)pBounds).getWidth(), ((RectangularShape)pBounds).getHeight() - this.timeSeriesControlPanelNode.getFullBounds().getHeight());
            this.timeSeriesControlPanelNode.setOffset(((RectangularShape)pBounds).getX() + ((RectangularShape)pBounds).getWidth() / 2.0 - this.timeSeriesControlPanelNode.getFullBounds().getWidth() / 2.0, this.graphSetNode.getFullBounds().getMaxY() - 10.0);
            this.background.setPathTo(pBounds);
        }
    }

    public void setFlowLayout() {
        this.graphSetNode.setFlowLayout();
    }

    public void setAlignedLayout() {
        this.graphSetNode.setAlignedLayout();
    }

    public void forceRepaintGraphs() {
        this.graphSetNode.forceRepaintGraphs();
    }

    public void forceRelayout() {
        this.graphSetNode.forceRelayout();
    }
}

