/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.text.DecimalFormat;

public class ReadoutTitleNode
extends PNode {
    private ShadowHTMLNode titleNode;
    private ShadowPText valueNode;
    private ShadowHTMLNode unitsNode;
    private ControlGraphSeries series;
    private DecimalFormat decimalFormat;
    private PhetPPath background;
    private double insetX = 2.0;
    private double insetY = 2.0;

    public ReadoutTitleNode(final ControlGraphSeries controlGraphSeries) {
        this.series = controlGraphSeries;
        this.decimalFormat = controlGraphSeries.getNumberFormat();
        this.titleNode = new ShadowHTMLNode();
        this.titleNode.setFont(this.getTitleFont());
        this.titleNode.setColor(controlGraphSeries.getColor());
        this.valueNode = new ShadowPText();
        this.valueNode.setFont(this.getTitleFont());
        this.valueNode.setTextPaint(controlGraphSeries.getColor());
        this.unitsNode = new ShadowHTMLNode(controlGraphSeries.getUnits());
        this.unitsNode.setFont(this.getTitleFont());
        this.unitsNode.setColor(controlGraphSeries.getColor());
        if (this.isLowRes()) {
            this.titleNode.setShadowColor(new Color(255, 255, 255, 255));
            this.valueNode.setShadowColor(new Color(255, 255, 255, 255));
            this.unitsNode.setShadowColor(new Color(255, 255, 255, 255));
        }
        this.background = new PhetPPath(Color.white);
        this.addChild(this.background);
        this.addChild(this.titleNode);
        this.addChild(this.valueNode);
        this.addChild(this.unitsNode);
        this.background.translate(this.insetX, this.insetY);
        this.titleNode.translate(this.insetX, this.insetY);
        controlGraphSeries.getTemporalVariable().addListener(new IVariable.Listener(){

            public void valueChanged() {
                ReadoutTitleNode.this.updateText();
            }
        });
        controlGraphSeries.addListener(new ControlGraphSeries.Adapter(){

            public void unitsChanged() {
                ReadoutTitleNode.this.unitsNode.setHtml(controlGraphSeries.getUnits());
                ReadoutTitleNode.this.updateText();
            }
        });
        if (controlGraphSeries.getCharacterName() != null) {
            this.titleNode.setHtml("<html>" + controlGraphSeries.getAbbr() + "<sub>" + controlGraphSeries.getCharacterName() + "</sub>= ");
        } else {
            this.titleNode.setHtml(controlGraphSeries.getAbbr() + "= ");
        }
        this.valueNode.setOffset(this.titleNode.getFullBounds().getWidth() + 3.0, 3.0);
        this.updateText();
    }

    private Font getTitleFont() {
        return new Font(PhetFont.getDefaultFontName(), 1, this.isLowRes() ? 12 : 14);
    }

    private boolean isLowRes() {
        return Toolkit.getDefaultToolkit().getScreenSize().width <= 1024;
    }

    public ControlGraphSeries getSeries() {
        return this.series;
    }

    protected void updateText() {
        this.setValueText(this.decimalFormat.format(this.getValueToDisplay()));
    }

    private void setValueText(String string) {
        this.valueNode.setText(string);
        double d = this.valueNode.getFullBounds().getMaxY();
        this.unitsNode.setOffset(this.valueNode.getFullBounds().getMaxX() + 3.0, d - this.unitsNode.getFullBounds().getHeight());
        this.background.setPathTo(RectangleUtils.expand(this.titleNode.getFullBounds().createUnion(this.unitsNode.getFullBounds()), this.insetX, this.insetY));
    }

    public double getPreferredWidth() {
        this.setValueText("MMM.MM");
        double d = this.getFullBounds().getWidth();
        this.updateText();
        return d;
    }

    protected double getValueToDisplay() {
        return this.series.getTemporalVariable().getValue();
    }
}

