/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartCursorNode;
import edu.colorado.phet.common.motion.graphs.ControlGraph;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.motion.model.UpdateableObject;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ZoomControlNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import java.util.ArrayList;
import org.jfree.chart.JFreeChart;

public class MotionControlGraph
extends ControlGraph {
    private ArrayList listeners = new ArrayList();
    private JFreeChartCursorNode jFreeChartCursorNode;
    private UpdateableObject updateableObject;
    private UpdateStrategy updateStrategy;
    private TimeSeriesModel timeSeriesModel;

    public MotionControlGraph(PhetPCanvas phetPCanvas, ControlGraphSeries controlGraphSeries, String string, String string2, double d, double d2, boolean bl, TimeSeriesModel timeSeriesModel, UpdateStrategy updateStrategy, double d3, UpdateableObject updateableObject) {
        this(ControlGraph.createDefaultChart(string2), phetPCanvas, controlGraphSeries, string, string2, d, d2, bl, timeSeriesModel, updateStrategy, d3, updateableObject);
    }

    public MotionControlGraph(JFreeChart jFreeChart, PhetPCanvas phetPCanvas, ControlGraphSeries controlGraphSeries, String string, String string2, double d, double d2, boolean bl, final TimeSeriesModel timeSeriesModel, UpdateStrategy updateStrategy, double d3, UpdateableObject updateableObject) {
        super(jFreeChart, phetPCanvas, controlGraphSeries, d, d2, timeSeriesModel, d3);
        this.updateableObject = updateableObject;
        this.timeSeriesModel = timeSeriesModel;
        this.updateStrategy = updateStrategy;
        this.addHorizontalZoomListener(new ZoomControlNode.ZoomListener(){

            public void zoomedOut() {
                MotionControlGraph.this.notifyZoomChanged();
            }

            public void zoomedIn() {
                MotionControlGraph.this.notifyZoomChanged();
            }
        });
        this.setEditable(bl);
        this.jFreeChartCursorNode = new JFreeChartCursorNode(this.getJFreeChartNode());
        this.addChild(this.jFreeChartCursorNode);
        timeSeriesModel.addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                MotionControlGraph.this.jFreeChartCursorNode.setTime(timeSeriesModel.getTime());
            }
        });
        this.jFreeChartCursorNode.addListener(new JFreeChartCursorNode.Listener(){

            public void cursorTimeChanged() {
                timeSeriesModel.setPlaybackTime(MotionControlGraph.this.jFreeChartCursorNode.getTime());
            }
        });
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void modeChanged() {
                MotionControlGraph.this.updateCursorVisible();
            }

            public void pauseChanged() {
                MotionControlGraph.this.updateCursorLocation();
                MotionControlGraph.this.updateCursorVisible();
            }
        });
        this.jFreeChartCursorNode.addListener(new JFreeChartCursorNode.Listener(){

            public void cursorTimeChanged() {
                timeSeriesModel.setPlaybackMode();
                timeSeriesModel.setPlaybackTime(MotionControlGraph.this.jFreeChartCursorNode.getTime());
            }
        });
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void dataSeriesChanged() {
                MotionControlGraph.this.jFreeChartCursorNode.setMaxDragTime(timeSeriesModel.getRecordTime());
            }

            public void dataSeriesCleared() {
                MotionControlGraph.this.clear();
                MotionControlGraph.this.getDynamicJFreeChartNode().forceUpdateAll();
            }
        });
        this.updateCursorVisible();
        this.addListener(new ControlGraph.Adapter(){

            public void controlFocusGrabbed() {
                MotionControlGraph.this.handleControlFocusGrabbed();
            }
        });
    }

    protected void handleControlFocusGrabbed() {
        super.handleControlFocusGrabbed();
        if (this.updateStrategy != null) {
            this.updateableObject.setUpdateStrategy(this.updateStrategy);
        }
    }

    private void updateCursorLocation() {
        this.jFreeChartCursorNode.setTime(this.timeSeriesModel.getTime());
    }

    private void updateCursorVisible() {
        this.jFreeChartCursorNode.setVisible(this.timeSeriesModel.isPlaybackMode() || this.timeSeriesModel.isPaused());
    }

    public boolean hasListener(Listener listener) {
        return this.listeners.contains(listener);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyZoomChanged() {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).horizontalZoomChanged(this);
            }
        }
    }

    public static interface Listener {
        public void horizontalZoomChanged(MotionControlGraph var1);
    }
}

